/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.RequestInfo;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";
    public static final String REQUEST_INTERRUPTED_HEADER = "dspace.request.interrupted.header";
    public static final String REQUEST_INTERRUPTED_MESSAGE = "dspace.request.interrupted.message";
    public static final String REQUEST_INTERRUPTED_CHARACTERS = "dspace.request.interrupted.characters";
    private static final String CURRENT_IP_ADDRESS = "dspace.user.ip";
    private static final String EFFECTIVE_USER_ID = "dspace.user.effective";
    private static final String AUTHENTICATED_USER_ID = "dspace.user.authenticated";

    public static Context Authenticate(Map objectModel, String email, String password, String realm) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn(context, request, context.getCurrentUser());
        } else {
            int explicitStatus = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, (String)realm, (HttpServletRequest)request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.logIn(context, request, context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context AuthenticateImplicit(Map objectModel) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        int implicitStatus = AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn(context, request, context.getCurrentUser());
        }
        return context;
    }

    private static void logIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        int[] groupIDs;
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        if (!AuthorizeManager.isAdmin((Context)context) && !SystemwideAlerts.canUserStartSession()) {
            context.setCurrentUser(null);
            return;
        }
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute(CURRENT_IP_ADDRESS, (Object)request.getRemoteAddr());
        session.setAttribute(EFFECTIVE_USER_ID, (Object)eperson.getID());
        session.setAttribute(AUTHENTICATED_USER_ID, (Object)eperson.getID());
    }

    public static void logIn(Map objectModel, EPerson eperson) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        AuthenticationUtil.logIn(context, request, eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            String address;
            Integer id = (Integer)session.getAttribute(EFFECTIVE_USER_ID);
            Integer realid = (Integer)session.getAttribute(AUTHENTICATED_USER_ID);
            if (id != null && (address = (String)session.getAttribute(CURRENT_IP_ADDRESS)) != null && address.equals(request.getRemoteAddr())) {
                int[] groupIDs;
                EPerson eperson = EPerson.find((Context)context, (int)id);
                context.setCurrentUser(eperson);
                if (!AuthorizeManager.isAdmin((Context)context) && !SystemwideAlerts.canUserMaintainSession()) {
                    EPerson realEPerson = EPerson.find((Context)context, (int)realid);
                    Group administrators = Group.find((Context)context, (int)1);
                    if (!administrators.isMember(realEPerson)) {
                        context.setCurrentUser(null);
                        return;
                    }
                }
                for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
                    context.setSpecialGroup(groupID);
                }
            }
        }
    }

    public static void loginAs(Context context, HttpServletRequest request, EPerson loginAs) throws SQLException, AuthorizeException {
        int[] groupIDs;
        if (!ConfigurationManager.getBooleanProperty((String)"xmlui.user.assumelogin", (boolean)false)) {
            return;
        }
        if (!AuthorizeManager.isAdmin((Context)context)) {
            throw new AuthorizeException("Only site administrators may assume login as another user.");
        }
        HttpSession session = request.getSession(false);
        Integer authenticatedID = (Integer)session.getAttribute(AUTHENTICATED_USER_ID);
        if (context.getCurrentUser().getID() != authenticatedID.intValue()) {
            throw new AuthorizeException("Only authenticated users whom are administrators may assume the login as another user.");
        }
        if (loginAs == null) {
            return;
        }
        Group administrators = Group.find((Context)context, (int)1);
        if (administrators.isMember(loginAs)) {
            throw new AuthorizeException("You may not assume the login as another super administrator.");
        }
        context.setCurrentUser(loginAs);
        for (int groupID : groupIDs = AuthenticationManager.getSpecialGroups((Context)context, (HttpServletRequest)request)) {
            context.setSpecialGroup(groupID);
        }
        session.setAttribute(EFFECTIVE_USER_ID, (Object)loginAs.getID());
    }

    public static void logOut(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession();
        if (session.getAttribute(EFFECTIVE_USER_ID) != null && session.getAttribute(AUTHENTICATED_USER_ID) != null) {
            Integer effectiveID = (Integer)session.getAttribute(EFFECTIVE_USER_ID);
            Integer authenticatedID = (Integer)session.getAttribute(AUTHENTICATED_USER_ID);
            if (effectiveID.intValue() != authenticatedID.intValue()) {
                EPerson authenticatedUser = EPerson.find((Context)context, (int)authenticatedID);
                context.setCurrentUser(authenticatedUser);
                session.setAttribute(EFFECTIVE_USER_ID, (Object)authenticatedID);
                return;
            }
        }
        context.setCurrentUser(null);
        session.removeAttribute(EFFECTIVE_USER_ID);
        session.removeAttribute(AUTHENTICATED_USER_ID);
        session.removeAttribute(CURRENT_IP_ADDRESS);
    }

    public static boolean canSelfRegister(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        if (SystemwideAlerts.canUserStartSession()) {
            return AuthenticationManager.canSelfRegister((Context)context, (HttpServletRequest)request, (String)email);
        }
        return false;
    }

    public static boolean allowSetPassword(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        return AuthenticationManager.allowSetPassword((Context)context, (HttpServletRequest)request, (String)email);
    }

    public static EPerson createNewEperson(Map objectModel, String email) throws SQLException, AuthorizeException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext(objectModel);
        context.setIgnoreAuthorization(true);
        EPerson eperson = EPerson.create((Context)context);
        eperson.setEmail(email);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        eperson.update();
        context.setIgnoreAuthorization(false);
        AuthenticationManager.initEPerson((Context)context, (HttpServletRequest)request, (EPerson)eperson);
        return eperson;
    }

    public static boolean isInterupptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        Object interruptedObject = session.getAttribute(REQUEST_INTERRUPTED);
        return interruptedObject instanceof RequestInfo;
    }

    public static void interruptRequest(Map objectModel, String header, String message, String characters) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        RequestInfo interruptedRequest = new RequestInfo(request);
        session.setAttribute(REQUEST_INTERRUPTED, (Object)interruptedRequest);
        session.setAttribute(REQUEST_RESUME, null);
        session.setAttribute(REQUEST_INTERRUPTED_HEADER, (Object)header);
        session.setAttribute(REQUEST_INTERRUPTED_MESSAGE, (Object)message);
        session.setAttribute(REQUEST_INTERRUPTED_CHARACTERS, (Object)characters);
    }

    public static String resumeInterruptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        session.setAttribute(REQUEST_INTERRUPTED_HEADER, null);
        session.setAttribute(REQUEST_INTERRUPTED_MESSAGE, null);
        session.setAttribute(REQUEST_INTERRUPTED_CHARACTERS, null);
        Object interruptedObject = session.getAttribute(REQUEST_INTERRUPTED);
        if (interruptedObject instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)interruptedObject;
            session.setAttribute(REQUEST_INTERRUPTED, null);
            session.setAttribute(REQUEST_RESUME, (Object)interruptedRequest);
            return interruptedRequest.getServletPath();
        }
        return null;
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute(REQUEST_RESUME);
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute(REQUEST_INTERRUPTED, null);
                session.setAttribute(REQUEST_RESUME, null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }
}

