/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class RestrictedItem
extends AbstractDSpaceTransformer {
    private static final Message T_title = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.title");
    private static final Message T_dspace_home = RestrictedItem.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.trail");
    private static final Message T_head_resource = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_resource");
    private static final Message T_head_community = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_community");
    private static final Message T_head_collection = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_collection");
    private static final Message T_head_item = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_item");
    private static final Message T_head_bitstream = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.head_bitstream");
    private static final Message T_para_resource = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_resource");
    private static final Message T_para_community = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_community");
    private static final Message T_para_collection = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_collection");
    private static final Message T_para_item = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_item");
    private static final Message T_para_bitstream = RestrictedItem.message((String)"xmlui.ArtifactBrowser.RestrictedItem.para_bitstream");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        Division unauthorized = body.addDivision("unauthorized-resource", "primary");
        if (dso == null) {
            unauthorized.setHead(T_head_resource);
            unauthorized.addPara(T_para_resource);
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            unauthorized.setHead(T_head_community);
            unauthorized.addPara(T_para_community.parameterize(new Object[]{community.getMetadata("name")}));
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            unauthorized.setHead(T_head_collection);
            unauthorized.addPara(T_para_collection.parameterize(new Object[]{collection.getMetadata("name")}));
        } else if (dso instanceof Item) {
            if (request.getParameter("bitstreamId") != null) {
                String identifier = "unknown";
                try {
                    Bitstream bit = Bitstream.find((Context)this.context, (int)new Integer(request.getParameter("bitstreamId")));
                    if (bit != null) {
                        identifier = bit.getName();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                unauthorized.setHead(T_head_bitstream);
                unauthorized.addPara(T_para_bitstream.parameterize(new Object[]{identifier}));
            } else {
                String identifier = "unknown";
                String handle = dso.getHandle();
                identifier = handle == null || "".equals(handle) ? "internal ID: " + dso.getID() : "hdl:" + handle;
                unauthorized.setHead(T_head_item);
                unauthorized.addPara(T_para_item.parameterize(new Object[]{identifier}));
            }
        } else {
            unauthorized.setHead(T_head_resource);
            unauthorized.addPara(T_para_resource);
        }
    }
}

