/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.utils.UsageEvent;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.PluginManager;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class ItemViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(ItemViewer.class);
    private static final Message T_dspace_home = ItemViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.trail");
    private static final Message T_show_simple = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.show_simple");
    private static final Message T_show_full = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.show_full");
    private static final Message T_head_parent_collections = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.head_parent_collections");
    private SourceValidity validity = null;
    private DisseminationCrosswalk xHTMLHeadCrosswalk = null;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)(dso.getHandle() + "full:" + ItemViewer.showFullItem(this.objectModel))));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        DSpaceObject dso = null;
        if (this.validity == null) {
            try {
                dso = HandleUtil.obtainHandle(this.objectModel);
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(dso);
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_item", (String)("handle=" + (dso == null ? "" : dso.getHandle()))));
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        String title = ItemViewer.getItemTitle(item);
        if (title != null) {
            pageMeta.addMetadata("title").addContent(title);
        } else {
            pageMeta.addMetadata("title").addContent(item.getHandle());
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((DSpaceObject)item, pageMeta, this.contextPath);
        pageMeta.addTrail().addContent(T_trail);
        if (this.xHTMLHeadCrosswalk == null) {
            this.xHTMLHeadCrosswalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)"XHTML_HEAD_ITEM");
        }
        try {
            List l = this.xHTMLHeadCrosswalk.disseminateList((DSpaceObject)item);
            StringWriter sw = new StringWriter();
            XMLOutputter xmlo = new XMLOutputter();
            for (int i = 0; i < l.size(); ++i) {
                Element e = (Element)l.get(i);
                e.setNamespace(null);
                xmlo.output(e, (Writer)sw);
            }
            pageMeta.addMetadata("xhtml_head_item").addContent(sw.toString());
        }
        catch (CrosswalkException ce) {
            throw new WingException((Throwable)ce);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String link;
        String link2;
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        new UsageEvent().fire(ObjectModelHelper.getRequest((Map)this.objectModel), this.context, 1, 2, item.getID());
        Division division = body.addDivision("item-view", "primary");
        String title = ItemViewer.getItemTitle(item);
        if (title != null) {
            division.setHead(title);
        } else {
            division.setHead(item.getHandle());
        }
        Para showfullPara = division.addPara(null, "item-view-toggle item-view-toggle-top");
        if (ItemViewer.showFullItem(this.objectModel)) {
            link2 = this.contextPath + "/handle/" + item.getHandle();
            showfullPara.addXref(link2).addContent(T_show_simple);
        } else {
            link2 = this.contextPath + "/handle/" + item.getHandle() + "?show=full";
            showfullPara.addXref(link2).addContent(T_show_full);
        }
        ReferenceSet referenceSet = ItemViewer.showFullItem(this.objectModel) ? division.addReferenceSet("collection-viewer", "detailView") : division.addReferenceSet("collection-viewer", "summaryView");
        ReferenceSet appearsInclude = referenceSet.addReference((Object)item).addReferenceSet("detailList", null, "hierarchy");
        appearsInclude.setHead(T_head_parent_collections);
        for (Collection collection : item.getCollections()) {
            appearsInclude.addReference((Object)collection);
        }
        showfullPara = division.addPara(null, "item-view-toggle item-view-toggle-bottom");
        if (ItemViewer.showFullItem(this.objectModel)) {
            link = this.contextPath + "/handle/" + item.getHandle();
            showfullPara.addXref(link).addContent(T_show_simple);
        } else {
            link = this.contextPath + "/handle/" + item.getHandle() + "?show=full";
            showfullPara.addXref(link).addContent(T_show_full);
        }
    }

    public static boolean showFullItem(Map objectModel) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String show = request.getParameter("show");
        return show != null && show.length() > 0;
    }

    public static String getItemTitle(Item item) {
        DCValue[] titles = item.getDC("title", "*", "*");
        String title = titles != null && titles.length > 0 ? titles[0].value : null;
        return title;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

