/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.utils.UsageEvent;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CollectionViewer.class);
    private static final Message T_dspace_home = CollectionViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_full_text_search = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.full_text_search");
    private static final Message T_go = CollectionViewer.message((String)"xmlui.general.go");
    public static final Message T_untitled = CollectionViewer.message((String)"xmlui.general.untitled");
    private static final Message T_head_browse = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.head_browse");
    private static final Message T_browse_titles = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.browse_titles");
    private static final Message T_browse_authors = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.browse_authors");
    private static final Message T_browse_dates = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.browse_dates");
    private static final Message T_advanced_search_link = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.advanced_search_link");
    private static final Message T_head_recent_submissions = CollectionViewer.message((String)"xmlui.ArtifactBrowser.CollectionViewer.head_recent_submissions");
    private static final int RECENT_SUBMISISONS = 5;
    private List<BrowseItem> recentSubmissionItems;
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Collection collection = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Collection)) {
                    return null;
                }
                collection = (Collection)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add((DSpaceObject)collection);
                for (BrowseItem item : this.getRecientlySubmittedIems(collection)) {
                    validity.add((DSpaceObject)item);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_collection", (String)("collection_id=" + (collection == null ? "" : Integer.valueOf(collection.getID())))));
        }
        return this.validity;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        String name = collection.getMetadata("name");
        if (name == null || name.length() == 0) {
            pageMeta.addMetadata("title").addContent(T_untitled);
        } else {
            pageMeta.addMetadata("title").addContent(name);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((DSpaceObject)collection, pageMeta, this.contextPath);
        String formats = ConfigurationManager.getProperty((String)"webui.feed.formats");
        if (formats != null) {
            for (String format : formats.split(",")) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + collection.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        new UsageEvent().fire(ObjectModelHelper.getRequest((Map)this.objectModel), this.context, 1, 3, collection.getID());
        Division home = body.addDivision("collection-home", "primary repository collection");
        String name = collection.getMetadata("name");
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        Division search = home.addDivision("collection-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("collection-search", this.contextPath + "/handle/" + collection.getHandle() + "/search", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
        query.addPara().addXref(this.contextPath + "/handle/" + collection.getHandle() + "/advanced-search", T_advanced_search_link);
        Division browseDiv = search.addDivision("collection-browse", "secondary browse");
        org.dspace.app.xmlui.wing.element.List browse = browseDiv.addList("collection-browse", "simple", "collection-browse");
        browse.setHead(T_head_browse);
        String url = this.contextPath + "/handle/" + collection.getHandle();
        browse.addItemXref(url + "/browse?type=title", T_browse_titles);
        browse.addItemXref(url + "/browse?type=author", T_browse_authors);
        browse.addItemXref(url + "/browse?type=dateissued", T_browse_dates);
        Division viewer = home.addDivision("collection-view", "secondary");
        ReferenceSet mainInclude = viewer.addReferenceSet("collection-view", "detailView");
        mainInclude.addReference((Object)collection);
        List<BrowseItem> items = this.getRecientlySubmittedIems(collection);
        Division lastSubmittedDiv = home.addDivision("collection-recent-submission", "secondary recent-submission");
        lastSubmittedDiv.setHead(T_head_recent_submissions);
        ReferenceSet lastSubmitted = lastSubmittedDiv.addReferenceSet("collection-last-submitted", "summaryList", null, "recent-submissions");
        for (BrowseItem item : items) {
            lastSubmitted.addReference((Object)item);
        }
    }

    private List<BrowseItem> getRecientlySubmittedIems(Collection collection) throws SQLException {
        if (this.recentSubmissionItems != null) {
            return this.recentSubmissionItems;
        }
        String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
        BrowserScope scope = new BrowserScope(this.context);
        scope.setCollection(collection);
        scope.setResultsPerPage(5);
        try {
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(this.context);
            this.recentSubmissionItems = be.browse(scope).getResults();
        }
        catch (SortException se) {
            log.error((Object)"Caught SortException", (Throwable)se);
        }
        catch (BrowseException bex) {
            log.error((Object)"Caught BrowseException", (Throwable)bex);
        }
        return this.recentSubmissionItems;
    }

    @Override
    public void recycle() {
        this.recentSubmissionItems = null;
        this.validity = null;
        super.recycle();
    }
}

