/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.WorkflowTools;
import org.swordapp.server.SwordError;

public class SwordUrlManager {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private String swordPath = this.configurationService.getProperty("swordv2-server.path", "swordv2");
    private String dspaceUrl = this.configurationService.getProperty("dspace.server.url");
    private final SwordConfigurationDSpace config;
    private final Context context;

    public SwordUrlManager(SwordConfigurationDSpace config, Context context) {
        this.config = config;
        this.context = context;
    }

    public String getDepositLocation(Collection collection) throws DSpaceSwordException {
        return this.getBaseCollectionUrl() + "/" + collection.getHandle();
    }

    public String getDepositLocation(Community community) throws DSpaceSwordException {
        if (this.config.allowCommunityDeposit()) {
            return this.getBaseCollectionUrl() + "/" + community.getHandle();
        }
        return null;
    }

    public String getSwordBaseUrl() throws DSpaceSwordException {
        Object sUrl = this.configurationService.getProperty("swordv2-server.url");
        if (sUrl == null || "".equals(sUrl)) {
            if (this.dspaceUrl == null || "".equals(this.dspaceUrl)) {
                throw new DSpaceSwordException("Unable to construct service document urls, due to missing/invalid config in sword2.url and/or dspace.server.url");
            }
            sUrl = this.dspaceUrl + "/" + this.swordPath;
        }
        return sUrl;
    }

    public Item getItem(Context context, String location) throws DSpaceSwordException, SwordError {
        try {
            String baseUrl = this.getSwordBaseUrl();
            String emBaseUrl = baseUrl + "/edit-media/";
            String eBaseUrl = baseUrl + "/edit/";
            String sBaseUrl = baseUrl + "/statement/";
            String cBaseUrl = null;
            if (location.startsWith(emBaseUrl)) {
                cBaseUrl = emBaseUrl;
            } else if (location.startsWith(eBaseUrl)) {
                cBaseUrl = eBaseUrl;
            } else if (location.startsWith(sBaseUrl)) {
                cBaseUrl = sBaseUrl;
            } else {
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "The item URL is invalid");
            }
            String iid = location.substring(cBaseUrl.length());
            if (iid.endsWith(".atom")) {
                iid = iid.substring(0, iid.length() - ".atom".length());
            } else if (iid.endsWith(".rdf")) {
                iid = iid.substring(0, iid.length() - ".rdf".length());
            }
            Item item = (Item)this.itemService.findByIdOrLegacyId(context, iid);
            return item;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException("There was a problem resolving the item", e);
        }
    }

    public String getTypeSuffix(Context context, String location) {
        String tail = location.substring(location.lastIndexOf("/"));
        int typeSeparator = tail.lastIndexOf(".");
        if (typeSeparator == -1) {
            return null;
        }
        return tail.substring(typeSeparator + 1);
    }

    public boolean isFeedRequest(Context context, String url) {
        return url.endsWith(".atom");
    }

    public Collection getCollection(Context context, String location) throws DSpaceSwordException, SwordError {
        try {
            String baseUrl = this.getBaseCollectionUrl();
            if (baseUrl.length() == location.length()) {
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "The deposit URL is incomplete");
            }
            String handle = location.substring(baseUrl.length());
            if (handle.startsWith("/")) {
                handle = handle.substring(1);
            }
            if ("".equals(handle)) {
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "The deposit URL is incomplete");
            }
            DSpaceObject dso = this.handleService.resolveToObject(context, handle);
            if (dso == null) {
                return null;
            }
            if (!(dso instanceof Collection)) {
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "The deposit URL does not resolve to a valid collection");
            }
            return (Collection)dso;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException("There was a problem resolving the collection", e);
        }
    }

    public String constructSubServiceUrl(Community community) throws DSpaceSwordException {
        String base = this.getBaseServiceDocumentUrl();
        String handle = community.getHandle();
        return base + "/" + handle;
    }

    public String constructSubServiceUrl(Collection collection) throws DSpaceSwordException {
        String base = this.getBaseServiceDocumentUrl();
        String handle = collection.getHandle();
        return base + "/" + handle;
    }

    public DSpaceObject extractDSpaceObject(String url) throws DSpaceSwordException, SwordError {
        try {
            String sdBase = this.getBaseServiceDocumentUrl();
            if (url.startsWith(sdBase)) {
                DSpaceObject dso;
                if ((url = url.substring(sdBase.length())).startsWith("/")) {
                    url = url.substring(1);
                }
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                if ((dso = this.handleService.resolveToObject(this.context, url)) == null) {
                    return null;
                }
                if (dso instanceof Collection || dso instanceof Community) {
                    return dso;
                }
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "Service Document request does not refer to a DSpace Collection or Community");
            }
            throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "Unable to recognise URL as a valid service document: " + url);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public String getBaseServiceDocumentUrl() throws DSpaceSwordException {
        String sdUrl = this.configurationService.getProperty("swordv2-server.servicedocument.url");
        if (sdUrl == null || "".equals(sdUrl)) {
            if (this.dspaceUrl == null || "".equals(this.dspaceUrl)) {
                throw new DSpaceSwordException("Unable to construct service document urls, due to missing/invalid config in swordv2-server.cfg servicedocument.url and/or dspace.server.url");
            }
            sdUrl = this.buildSWORDUrl("servicedocument");
        }
        return sdUrl;
    }

    public String getBaseCollectionUrl() throws DSpaceSwordException {
        String depositUrl = this.configurationService.getProperty("swordv2-server.collection.url");
        if (depositUrl == null || "".equals(depositUrl)) {
            if (this.dspaceUrl == null || "".equals(this.dspaceUrl)) {
                throw new DSpaceSwordException("Unable to construct deposit urls, due to missing/invalid config in swordv2-server.cfg deposit.url and/or dspace.server.url");
            }
            depositUrl = this.buildSWORDUrl("collection");
        }
        return depositUrl;
    }

    public boolean isBaseServiceDocumentUrl(String url) throws DSpaceSwordException {
        return this.getBaseServiceDocumentUrl().equals(url);
    }

    public String getBitstreamUrl(Bitstream bitstream) throws DSpaceSwordException {
        try {
            List bundles = bitstream.getBundles();
            Bundle parent = null;
            if (bundles.isEmpty()) {
                throw new DSpaceSwordException("Encountered orphaned bitstream");
            }
            parent = (Bundle)bundles.get(0);
            List items = parent.getItems();
            if (items.isEmpty()) {
                throw new DSpaceSwordException("Encountered orphaned bundle");
            }
            Item item = (Item)items.get(0);
            String handle = item.getHandle();
            Object bsLink = this.configurationService.getProperty("dspace.ui.url");
            bsLink = handle != null && !"".equals(handle) ? (String)bsLink + "/bitstream/" + handle + "/" + bitstream.getSequenceID() + "/" + bitstream.getName() : (String)bsLink + "/retrieve/" + bitstream.getID() + "/" + bitstream.getName();
            return bsLink;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public String getActionableBitstreamUrl(Bitstream bitstream) throws DSpaceSwordException {
        return this.getSwordBaseUrl() + "/edit-media/bitstream/" + bitstream.getID() + "/" + bitstream.getName();
    }

    public boolean isActionableBitstreamUrl(Context context, String url) {
        return url.contains("/edit-media/bitstream/");
    }

    public Bitstream getBitstream(Context context, String location) throws DSpaceSwordException, SwordError {
        try {
            String baseUrl = this.getSwordBaseUrl();
            String emBaseUrl = baseUrl + "/edit-media/bitstream/";
            if (!location.startsWith(emBaseUrl)) {
                throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/BadUrl", "The bitstream URL is invalid");
            }
            String bitstreamParts = location.substring(emBaseUrl.length());
            int firstSlash = bitstreamParts.indexOf("/");
            String bid = bitstreamParts.substring(0, firstSlash);
            Bitstream bitstream = (Bitstream)this.bitstreamService.findByIdOrLegacyId(context, bid);
            return bitstream;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException("There was a problem resolving the collection", e);
        }
    }

    public String getAtomStatementUri(Item item) throws DSpaceSwordException {
        return this.getSwordBaseUrl() + "/statement/" + item.getID() + ".atom";
    }

    public String getOreStatementUri(Item item) throws DSpaceSwordException {
        return this.getSwordBaseUrl() + "/statement/" + item.getID() + ".rdf";
    }

    public String getAggregationUrl(Item item) throws DSpaceSwordException {
        return this.getOreStatementUri(item) + "#aggregation";
    }

    public IRI getEditIRI(Item item) throws DSpaceSwordException {
        return new IRI(this.getSwordBaseUrl() + "/edit/" + item.getID());
    }

    public String getSplashUrl(Item item) throws DSpaceSwordException {
        WorkflowTools wft = new WorkflowTools();
        if (wft.isItemInWorkspace(this.context, item)) {
            String urlTemplate = this.configurationService.getProperty("swordv2-server.workspace.url-template");
            if (urlTemplate != null) {
                return urlTemplate.replace("#wsid#", Integer.toString(wft.getWorkspaceItem(this.context, item).getID()));
            }
        } else {
            if (wft.isItemInWorkflow(this.context, item)) {
                return null;
            }
            return this.handleService.getCanonicalForm(item.getHandle());
        }
        return null;
    }

    public IRI getContentUrl(Item item) throws DSpaceSwordException {
        return new IRI(this.getSwordBaseUrl() + "/edit-media/" + item.getID());
    }

    public IRI getMediaFeedUrl(Item item) throws DSpaceSwordException {
        return new IRI(this.getSwordBaseUrl() + "/edit-media/" + item.getID() + ".atom");
    }

    private String buildSWORDUrl(String path) {
        return this.dspaceUrl + "/" + this.swordPath + "/" + path;
    }
}

