/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;

public class SwordAuthenticator {
    private static Logger log = LogManager.getLogger(SwordAuthenticator.class);
    protected AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public boolean authenticates(Context context, String un, String pw) {
        int auth = this.authenticationService.authenticate(context, un, pw, null, null);
        return auth == 1;
    }

    private Context constructContext() throws DSpaceSwordException {
        Context context = new Context();
        context.setExtraLogInfo("session_id=0");
        return context;
    }

    public SwordContext authenticate(AuthCredentials auth) throws DSpaceSwordException, SwordError, SwordAuthException {
        SwordContext sc;
        Context context = this.constructContext();
        try {
            sc = this.authenticate(context, auth);
        }
        catch (RuntimeException | DSpaceSwordException | SwordAuthException | SwordError e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        return sc;
    }

    private SwordContext authenticate(Context context, AuthCredentials auth) throws SwordAuthException, SwordError, DSpaceSwordException {
        boolean mediated;
        String obo = auth.getOnBehalfOf();
        String un = auth.getUsername();
        String pw = auth.getPassword();
        if (StringUtils.isBlank((CharSequence)obo)) {
            obo = null;
        }
        if (!(mediated = this.configurationService.getBooleanProperty("swordv2-server.on-behalf-of.enable", false)) && obo != null) {
            log.error("Attempted mediated deposit on service not configured to do so");
            throw new SwordError("http://purl.org/net/sword/error/MediationNotAllowed", "Mediated deposit to this service is not permitted");
        }
        log.info(LogHelper.getHeader((Context)context, (String)"sword_authenticate", (String)("username=" + un + ",on_behalf_of=" + obo)));
        try {
            SwordContext sc = new SwordContext();
            EPerson ep = null;
            boolean authenticated = false;
            if (this.authenticates(context, un, pw)) {
                ep = context.getCurrentUser();
                if (ep != null) {
                    authenticated = true;
                    sc.setAuthenticated(ep);
                    List specialGroups = this.authenticationService.getSpecialGroups(context, null);
                    for (Group specialGroup : specialGroups) {
                        context.setSpecialGroup(specialGroup.getID());
                        log.debug("Adding Special Group id=" + specialGroup.getID());
                    }
                    sc.setAuthenticatorContext(context);
                    sc.setContext(context);
                }
                EPerson epObo = null;
                if (obo != null) {
                    epObo = this.ePersonService.findByEmail(context, obo);
                    if (epObo == null) {
                        epObo = this.ePersonService.findByNetid(context, obo);
                    }
                    if (epObo != null) {
                        sc.setOnBehalfOf(epObo);
                        Context oboContext = this.constructContext();
                        oboContext.setCurrentUser(epObo);
                        List specialGroups = this.authenticationService.getSpecialGroups(oboContext, null);
                        for (Group specialGroup : specialGroups) {
                            oboContext.setSpecialGroup(specialGroup.getID());
                            log.debug("Adding Special Group id=" + specialGroup.getID());
                        }
                        sc.setContext(oboContext);
                    } else {
                        authenticated = false;
                        throw new SwordError("http://purl.org/net/sword/error/TargetOwnerUnknown", "unable to identify on-behalf-of user: " + obo);
                    }
                }
            }
            if (!authenticated) {
                if (ep != null) {
                    log.info(LogHelper.getHeader((Context)context, (String)"sword_unable_to_set_user", (String)("username=" + un)));
                    throw new SwordAuthException("Unable to authenticate with the supplied credentials");
                }
                log.info(LogHelper.getHeader((Context)context, (String)"sword_unable_to_set_on_behalf_of", (String)("username=" + un + ",on_behalf_of=" + obo)));
                throw new SwordAuthException("Unable to authenticate the onBehalfOf account");
            }
            return sc;
        }
        catch (SQLException e) {
            log.error("caught exception: ", (Throwable)e);
            throw new DSpaceSwordException("There was a problem accessing the repository user database", e);
        }
    }

    public boolean canSubmit(SwordContext swordContext, DSpaceObject dso, VerboseDescription msg) throws DSpaceSwordException, SwordError {
        boolean submit = this.canSubmitTo(swordContext, dso);
        if (submit) {
            msg.append("User is authorised to submit to collection");
        } else {
            msg.append("User is not authorised to submit to collection");
        }
        return submit;
    }

    public boolean isUserAdmin(SwordContext swordContext) throws DSpaceSwordException {
        try {
            EPerson authenticated = swordContext.getAuthenticated();
            if (authenticated != null) {
                return this.authorizeService.isAdmin(swordContext.getAuthenticatorContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public boolean isOnBehalfOfAdmin(SwordContext swordContext) throws DSpaceSwordException {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        try {
            if (onBehalfOf != null) {
                return this.authorizeService.isAdmin(swordContext.getOnBehalfOfContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public boolean isUserInGroup(SwordContext swordContext, Group group) {
        EPerson authenticated = swordContext.getAuthenticated();
        if (authenticated != null) {
            return this.isInGroup(group, authenticated);
        }
        return false;
    }

    public boolean isOnBehalfOfInGroup(SwordContext swordContext, Group group) {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        if (onBehalfOf != null) {
            return this.isInGroup(group, onBehalfOf);
        }
        return false;
    }

    public boolean isInGroup(Group group, EPerson eperson) {
        List eps = group.getMembers();
        List groups = group.getMemberGroups();
        for (EPerson ep : eps) {
            if (!eperson.getID().equals(ep.getID())) continue;
            return true;
        }
        if (groups != null && !groups.isEmpty()) {
            for (Group group1 : groups) {
                if (!this.isInGroup(group1, eperson)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Community> getAllowedCommunities(SwordContext swordContext) throws DSpaceSwordException {
        try {
            Context context = swordContext.getContext();
            ArrayList<Community> allowed = new ArrayList<Community>();
            List comms = this.communityService.findAllTop(context);
            for (Community comm : comms) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)comm, 0);
                }
                if (!oboAllowed) {
                    oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)comm, 0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comm);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public List<Community> getCommunities(SwordContext swordContext, Community community) throws DSpaceSwordException {
        try {
            List comms = community.getSubcommunities();
            ArrayList<Community> allowed = new ArrayList<Community>();
            for (Community comm : comms) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)comm, 0);
                }
                if (!oboAllowed) {
                    oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)comm, 0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comm);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public List<Collection> getAllowedCollections(SwordContext swordContext) throws DSpaceSwordException {
        return this.getAllowedCollections(swordContext, null);
    }

    public List<Collection> getAllowedCollections(SwordContext swordContext, Community community) throws DSpaceSwordException {
        try {
            Context authContext = swordContext.getAuthenticatorContext();
            List cols = this.collectionService.findAuthorized(authContext, community, Arrays.asList(3, 11));
            ArrayList<Collection> allowed = new ArrayList<Collection>();
            if (swordContext.getOnBehalfOf() != null) {
                for (Collection col : cols) {
                    boolean oboAllowed = false;
                    if (!oboAllowed) {
                        oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)col, 3);
                    }
                    if (!oboAllowed) continue;
                    allowed.add(col);
                }
            } else {
                return cols;
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public List<Item> getAllowedItems(SwordContext swordContext, Collection collection) throws DSpaceSwordException {
        try {
            ArrayList<Item> allowed = new ArrayList<Item>();
            Iterator ii = this.itemService.findByCollection(swordContext.getContext(), collection);
            while (ii.hasNext()) {
                boolean add;
                boolean write;
                Item item = (Item)ii.next();
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                List bundles = item.getBundles("ORIGINAL");
                if (!authAllowed) {
                    write = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)item, 1);
                    add = false;
                    if (bundles.isEmpty()) {
                        add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)item, 3);
                    } else {
                        for (Bundle bundle : bundles) {
                            add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)bundle, 3);
                            if (add) continue;
                            break;
                        }
                    }
                    boolean bl = authAllowed = write && add;
                }
                if (!oboAllowed) {
                    write = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)item, 1);
                    add = false;
                    if (bundles.isEmpty()) {
                        add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)item, 3);
                    } else {
                        Bundle bundle;
                        Iterator iterator = bundles.iterator();
                        while (iterator.hasNext() && (!"ORIGINAL".equals((bundle = (Bundle)iterator.next()).getName()) || (add = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)bundle, 3)))) {
                        }
                    }
                    boolean bl = oboAllowed = write && add;
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(item);
            }
            return allowed;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public boolean canSubmitTo(SwordContext swordContext, Collection collection) throws DSpaceSwordException {
        try {
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            if (!authAllowed) {
                authAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getAuthenticatorContext(), (DSpaceObject)collection, 3);
            }
            if (!oboAllowed) {
                oboAllowed = this.authorizeService.authorizeActionBoolean(swordContext.getOnBehalfOfContext(), (DSpaceObject)collection, 3);
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    public boolean canSubmitTo(SwordContext swordContext, Item item) throws DSpaceSwordException {
        try {
            boolean isObo = swordContext.getOnBehalfOf() != null;
            Context allowContext = null;
            if (isObo) {
                if (!this.allowedToMediate(swordContext.getAuthenticatorContext())) {
                    return false;
                }
                allowContext = swordContext.getOnBehalfOfContext();
            } else {
                allowContext = swordContext.getAuthenticatorContext();
            }
            boolean write = this.authorizeService.authorizeActionBoolean(allowContext, (DSpaceObject)item, 1);
            List bundles = item.getBundles("ORIGINAL");
            boolean add = false;
            if (bundles.isEmpty()) {
                add = this.authorizeService.authorizeActionBoolean(allowContext, (DSpaceObject)item, 3);
            } else {
                Bundle bundle;
                Iterator iterator = bundles.iterator();
                while (iterator.hasNext() && (add = this.authorizeService.authorizeActionBoolean(allowContext, (DSpaceObject)(bundle = (Bundle)iterator.next()), 3))) {
                }
            }
            boolean allowed = write && add;
            return allowed;
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
    }

    private boolean allowedToMediate(Context context) {
        String[] mediators = this.configurationService.getArrayProperty("swordv2-server.on-behalf-of.update.mediators");
        if (mediators == null || mediators.length == 0) {
            return true;
        }
        EPerson eperson = context.getCurrentUser();
        if (eperson == null) {
            return false;
        }
        String email = eperson.getEmail();
        String netid = eperson.getNetid();
        for (String mediator : mediators) {
            String m = mediator.trim();
            if (email != null && m.equals(email.trim())) {
                return true;
            }
            if (netid == null || !m.equals(netid.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean canSubmitTo(SwordContext context, DSpaceObject dso) throws DSpaceSwordException {
        if (dso instanceof Collection) {
            return this.canSubmitTo(context, (Collection)dso);
        }
        return dso instanceof Item && this.canSubmitTo(context, (Item)dso);
    }
}

