/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class WorkflowTools {
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected WorkflowItemService workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    protected WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public boolean isItemInWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            return this.workflowItemService.findByItem(context, item) != null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public boolean isItemInWorkspace(Context context, Item item) throws DSpaceSwordException {
        try {
            return this.workspaceItemService.findByItem(context, item) != null;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public WorkflowItem getWorkflowItem(Context context, Item item) throws DSpaceSwordException {
        try {
            return this.workflowItemService.findByItem(context, item);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public WorkspaceItem getWorkspaceItem(Context context, Item item) throws DSpaceSwordException {
        try {
            return this.workspaceItemService.findByItem(context, item);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public void startWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            WorkspaceItem wsi = this.getWorkspaceItem(context, item);
            boolean notify = this.configurationService.getBooleanProperty("swordv2-server.workflow.notify");
            if (notify) {
                this.workflowService.start(context, wsi);
            } else {
                this.workflowService.startWithoutNotify(context, wsi);
            }
        }
        catch (IOException | SQLException | AuthorizeException | WorkflowException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public void stopWorkflow(Context context, Item item) throws DSpaceSwordException {
        try {
            WorkflowItem wfi = this.getWorkflowItem(context, item);
            if (wfi != null) {
                this.workflowService.abort(context, wfi, context.getCurrentUser());
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new DSpaceSwordException(e);
        }
    }
}

