/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordEntryDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.util.MultiFormatDateParser;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class ReceiptGenerator {
    private static final Logger log = LogManager.getLogger(ReceiptGenerator.class);
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    protected DepositReceipt createFileReceipt(Context context, DepositResult result, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        DepositReceipt receipt = new DepositReceipt();
        receipt.setLocation(new IRI(urlManager.getActionableBitstreamUrl(result.getOriginalDeposit())));
        receipt.setEmpty(true);
        return receipt;
    }

    protected DepositReceipt createMediaResourceReceipt(Context context, Item item, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        DepositReceipt receipt = new DepositReceipt();
        receipt.setLocation(urlManager.getContentUrl(item));
        return receipt;
    }

    protected DepositReceipt createReceipt(Context context, DepositResult result, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError, SwordServerException {
        return this.createReceipt(context, result, config, false);
    }

    protected DepositReceipt createReceipt(Context context, DepositResult result, SwordConfigurationDSpace config, boolean mediaResourceLocation) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        DepositReceipt receipt = new DepositReceipt();
        receipt.setAtomStatementURI(urlManager.getAtomStatementUri(result.getItem()));
        receipt.setOREStatementURI(urlManager.getOreStatementUri(result.getItem()));
        receipt.setEditIRI(urlManager.getEditIRI(result.getItem()));
        receipt.setSplashUri(urlManager.getSplashUrl(result.getItem()));
        receipt.setSwordEditIRI(urlManager.getEditIRI(result.getItem()));
        receipt.setTreatment(result.getTreatment());
        receipt.setContent(urlManager.getContentUrl(result.getItem()), "application/zip");
        receipt.addEditMediaIRI(urlManager.getContentUrl(result.getItem()), "application/zip");
        receipt.setMediaFeedIRI(urlManager.getMediaFeedUrl(result.getItem()));
        receipt.setLastModified(Date.from(result.getItem().getLastModified()));
        if (mediaResourceLocation) {
            receipt.setLocation(urlManager.getContentUrl(result.getItem()));
        } else {
            receipt.setLocation(urlManager.getEditIRI(result.getItem()));
        }
        try {
            Bitstream od = result.getOriginalDeposit();
            if (od != null) {
                receipt.setOriginalDeposit(urlManager.getActionableBitstreamUrl(od), od.getFormat(context).getMIMEType());
            }
            HashMap<String, String> derived = new HashMap<String, String>();
            List<Bitstream> drs = result.getDerivedResources();
            if (drs != null) {
                for (Bitstream bs : result.getDerivedResources()) {
                    derived.put(urlManager.getActionableBitstreamUrl(bs), bs.getFormat(context).getMIMEType());
                }
            }
            receipt.setDerivedResources(derived);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        this.addCategories(result, receipt);
        this.addPublishDate(result, receipt);
        SwordEntryDisseminator disseminator = SwordDisseminatorFactory.getEntryInstance();
        disseminator.disseminate(context, result.getItem(), receipt);
        StringBuilder rightsString = new StringBuilder();
        List bundles = result.getItem().getBundles();
        for (Bundle bundle : bundles) {
            if (!"LICENSE".equals(bundle.getName())) continue;
            List bss = bundle.getBitstreams();
            for (Bitstream bs : bss) {
                String url = urlManager.getBitstreamUrl(bs);
                rightsString.append(url).append(" ");
            }
        }
        receipt.getWrappedEntry().setRights(rightsString.toString());
        this.addLastUpdatedDate(result, receipt);
        receipt.setPackaging(config.getDisseminatePackaging());
        return receipt;
    }

    protected DepositReceipt createReceipt(Context context, Item item, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError, SwordServerException {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        DepositReceipt receipt = new DepositReceipt();
        receipt.setAtomStatementURI(urlManager.getAtomStatementUri(item));
        receipt.setOREStatementURI(urlManager.getOreStatementUri(item));
        receipt.setEditIRI(urlManager.getEditIRI(item));
        receipt.setLocation(urlManager.getEditIRI(item));
        receipt.setSplashUri(urlManager.getSplashUrl(item));
        receipt.setSwordEditIRI(urlManager.getEditIRI(item));
        receipt.setContent(urlManager.getContentUrl(item), "application/zip");
        receipt.addEditMediaIRI(urlManager.getContentUrl(item), "application/zip");
        receipt.setMediaFeedIRI(urlManager.getMediaFeedUrl(item));
        receipt.setLastModified(Date.from(item.getLastModified()));
        this.addCategories(item, receipt);
        this.addPublishDate(item, receipt);
        SwordEntryDisseminator disseminator = SwordDisseminatorFactory.getEntryInstance();
        disseminator.disseminate(context, item, receipt);
        StringBuilder rightsString = new StringBuilder();
        List bundles = item.getBundles();
        for (Bundle bundle : bundles) {
            if (!"LICENSE".equals(bundle.getName())) continue;
            List bss = bundle.getBitstreams();
            for (Bitstream bs : bss) {
                String url = urlManager.getBitstreamUrl(bs);
                rightsString.append(url).append(" ");
            }
        }
        receipt.getWrappedEntry().setRights(rightsString.toString());
        this.addLastUpdatedDate(item, receipt);
        receipt.setPackaging(config.getDisseminatePackaging());
        return receipt;
    }

    protected void addCategories(DepositResult result, DepositReceipt receipt) {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)result.getItem(), "dc.subject.*");
        if (dcv != null) {
            for (MetadataValue aDcv : dcv) {
                receipt.getWrappedEntry().addCategory("http://purl.org/dc/terms/", aDcv.getValue(), aDcv.getValue());
            }
        }
    }

    protected void addCategories(Item item, DepositReceipt receipt) {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.subject.*");
        if (dcv != null) {
            for (MetadataValue aDcv : dcv) {
                receipt.getWrappedEntry().addCategory("http://purl.org/dc/terms/", aDcv.getValue(), aDcv.getValue());
            }
        }
    }

    protected void addPublishDate(DepositResult result, DepositReceipt receipt) {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)result.getItem(), "dc.date.issued");
        if (dcv != null && !dcv.isEmpty()) {
            ZonedDateTime published = MultiFormatDateParser.parse((String)((MetadataValue)dcv.get(0)).getValue());
            receipt.getWrappedEntry().setPublished(Date.from(published.toInstant()));
        }
    }

    protected void addPublishDate(Item item, DepositReceipt receipt) {
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.date.issued");
        if (dcv != null && dcv.size() == 1) {
            ZonedDateTime published = MultiFormatDateParser.parse((String)((MetadataValue)dcv.get(0)).getValue());
            receipt.getWrappedEntry().setPublished(Date.from(published.toInstant()));
        }
    }

    protected void addLastUpdatedDate(DepositResult result, DepositReceipt receipt) {
        String config = this.configurationService.getProperty("swordv2-server.updated.field");
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)result.getItem(), config);
        if (dcv != null && dcv.size() == 1) {
            ZonedDateTime updated = MultiFormatDateParser.parse((String)((MetadataValue)dcv.get(0)).getValue());
            receipt.getWrappedEntry().setUpdated(Date.from(updated.toInstant()));
        }
    }

    protected void addLastUpdatedDate(Item item, DepositReceipt receipt) {
        String config = this.configurationService.getProperty("swordv2-server.updated.field");
        List dcv = this.itemService.getMetadataByMetadataString((DSpaceObject)item, config);
        if (dcv != null && dcv.size() == 1) {
            ZonedDateTime updated = MultiFormatDateParser.parse((String)((MetadataValue)dcv.get(0)).getValue());
            receipt.getWrappedEntry().setUpdated(Date.from(updated.toInstant()));
        }
    }
}

