/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class BinaryContentIngester
extends AbstractSwordContentIngester {
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    @Override
    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = this.workspaceItemService.create(context, collection, true);
                item = wsi.getItem();
            }
            Bitstream bs = this.itemService.createSingleBitstream(context, deposit.getInputStream(), item);
            BitstreamFormat format = this.getFormat(context, deposit.getFilename());
            bs.setName(context, deposit.getFilename());
            bs.setFormat(context, format);
            this.bitstreamService.update(context, (DSpaceObject)bs);
            this.itemService.addMetadata(context, (DSpaceObject)item, "dc", "title", null, null, "Untitled: " + deposit.getFilename());
            this.itemService.addMetadata(context, (DSpaceObject)item, "dc", "description", null, null, "Zip file deposted by SWORD without accompanying metadata");
            this.setUpdatedDate(context, item, verboseDescription);
            this.setSlug(context, item, deposit.getSlug(), verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setOriginalDeposit(bs);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    @Override
    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            List originals = item.getBundles();
            Bundle original = null;
            for (Bundle bundle : originals) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                original = bundle;
            }
            if (original == null) {
                original = this.bundleService.create(context, item, "ORIGINAL");
            }
            Bitstream bs = this.bitstreamService.create(context, original, deposit.getInputStream());
            BitstreamFormat format = this.getFormat(context, deposit.getFilename());
            bs.setFormat(context, format);
            bs.setName(context, deposit.getFilename());
            this.bitstreamService.update(context, (DSpaceObject)bs);
            this.setUpdatedDate(context, item, verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("ingest successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setOriginalDeposit(bs);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private String getTreatment() throws DSpaceSwordException {
        return "The package has been ingested and unpacked into the item.  Template metadata for the collection has been used, and a default title with the name of the file has been set";
    }
}

