/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.configuration;

import jakarta.servlet.Servlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.swordapp.server.servlets.CollectionServletDefault;
import org.swordapp.server.servlets.ContainerServletDefault;
import org.swordapp.server.servlets.MediaResourceServletDefault;
import org.swordapp.server.servlets.ServiceDocumentServletDefault;
import org.swordapp.server.servlets.StatementServletDefault;

@Configuration
public class SWORDv2WebConfig {
    @Value(value="${swordv2-server.path:swordv2}")
    private String swordv2Path;
    @Value(value="${swordv2-server.service-document-impl:org.dspace.sword2.ServiceDocumentManagerDSpace}")
    private String serviceDocImpl;
    @Value(value="${swordv2-server.collection-list-impl:org.dspace.sword2.CollectionListManagerDSpace}")
    private String collectionListImpl;
    @Value(value="${swordv2-server.collection-deposit-impl:org.dspace.sword2.CollectionDepositManagerDSpace}")
    private String collectionDepositImpl;
    @Value(value="${swordv2-server.media-resource-impl:org.dspace.sword2.MediaResourceManagerDSpace}")
    private String mediaResourceImpl;
    @Value(value="${swordv2-server.container-impl:org.dspace.sword2.ContainerManagerDSpace}")
    private String containerImpl;
    @Value(value="${swordv2-server.statement-impl:org.dspace.sword2.StatementManagerDSpace}")
    private String statementImpl;
    @Value(value="${swordv2-server.config-impl:org.dspace.sword2.SwordConfigurationDSpace}")
    private String configImpl;
    @Value(value="${swordv2-server.auth-type:Basic}")
    private String authenticationMethod;

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletContextInitializer swordv2ContextInitializer() {
        return servletContext -> {
            servletContext.setInitParameter("service-document-impl", this.serviceDocImpl);
            servletContext.setInitParameter("collection-list-impl", this.collectionListImpl);
            servletContext.setInitParameter("collection-deposit-impl", this.collectionDepositImpl);
            servletContext.setInitParameter("media-resource-impl", this.mediaResourceImpl);
            servletContext.setInitParameter("container-impl", this.containerImpl);
            servletContext.setInitParameter("statement-impl", this.statementImpl);
            servletContext.setInitParameter("config-impl", this.configImpl);
            servletContext.setInitParameter("authentication-method", this.authenticationMethod);
        };
    }

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletRegistrationBean swordv2ServiceDocumentBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new ServiceDocumentServletDefault(), new String[]{"/" + this.swordv2Path + "/servicedocument/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletRegistrationBean swordv2CollectionBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new CollectionServletDefault(), new String[]{"/" + this.swordv2Path + "/collection/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletRegistrationBean swordv2MediaResourceBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new MediaResourceServletDefault(), new String[]{"/" + this.swordv2Path + "/edit-media/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletRegistrationBean swordv2ContainerBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new ContainerServletDefault(), new String[]{"/" + this.swordv2Path + "/edit/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"swordv2-server.enabled"})
    public ServletRegistrationBean swordv2StatementBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new StatementServletDefault(), new String[]{"/" + this.swordv2Path + "/statement/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }
}

