/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordStatementDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.WorkflowTools;
import org.swordapp.server.OriginalDeposit;
import org.swordapp.server.ResourcePart;
import org.swordapp.server.Statement;

public abstract class GenericStatementDisseminator
implements SwordStatementDisseminator {
    protected SwordUrlManager urlManager;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    protected void populateStatement(Context context, Item item, Statement statement) throws DSpaceSwordException {
        String originalDepositBundle;
        this.urlManager = new SwordUrlManager(new SwordConfigurationDSpace(), context);
        List<String> includeBundles = this.getIncludeBundles();
        if (includeBundles.contains(originalDepositBundle = this.getOriginalDepositsBundle())) {
            List<OriginalDeposit> originalDeposits = this.getOriginalDeposits(context, item, originalDepositBundle);
            statement.setOriginalDeposits(originalDeposits);
        }
        Map<String, String> states = this.getStates(context, item);
        statement.setStates(states);
        includeBundles.remove(originalDepositBundle);
        List<ResourcePart> resources = this.getResourceParts(context, item, includeBundles);
        statement.setResources(resources);
        Date lastModified = this.getLastModified(context, item);
        statement.setLastModified(lastModified);
    }

    protected List<OriginalDeposit> getOriginalDeposits(Context context, Item item, String swordBundle) throws DSpaceSwordException {
        try {
            ArrayList<OriginalDeposit> originalDeposits = new ArrayList<OriginalDeposit>();
            List bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                if (!swordBundle.equals(bundle.getName())) continue;
                List bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    OriginalDeposit deposit = new OriginalDeposit(this.urlManager.getBitstreamUrl(bitstream));
                    deposit.setMediaType(bitstream.getFormat(context).getMIMEType());
                    deposit.setDepositedOn(this.getDateOfDeposit(item));
                    originalDeposits.add(deposit);
                }
            }
            return originalDeposits;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    protected Map<String, String> getStates(Context context, Item item) throws DSpaceSwordException {
        SwordConfigurationDSpace config = new SwordConfigurationDSpace();
        WorkflowTools wft = new WorkflowTools();
        HashMap<String, String> states = new HashMap<String, String>();
        if (item.isWithdrawn()) {
            String uri = config.getStateUri("withdrawn");
            String desc = config.getStateDescription("withdrawn");
            states.put(uri, desc);
        } else if (item.isArchived()) {
            String uri = config.getStateUri("archive");
            String desc = config.getStateDescription("archive");
            states.put(uri, desc);
        } else if (wft.isItemInWorkflow(context, item)) {
            String uri = config.getStateUri("workflow");
            String desc = config.getStateDescription("workflow");
            states.put(uri, desc);
        } else if (wft.isItemInWorkspace(context, item)) {
            String uri = config.getStateUri("workspace");
            String desc = config.getStateDescription("workspace");
            states.put(uri, desc);
        }
        return states;
    }

    protected List<ResourcePart> getResourceParts(Context context, Item item, List<String> includeBundles) throws DSpaceSwordException {
        try {
            ArrayList<ResourcePart> resources = new ArrayList<ResourcePart>();
            for (String bundleName : includeBundles) {
                List bundles = item.getBundles();
                for (Bundle bundle : bundles) {
                    if (!bundleName.equals(bundle.getName())) continue;
                    List bitstreams = bundle.getBitstreams();
                    for (Bitstream bitstream : bitstreams) {
                        ResourcePart part = new ResourcePart(this.urlManager.getActionableBitstreamUrl(bitstream));
                        part.setMediaType(bitstream.getFormat(context).getMIMEType());
                        resources.add(part);
                    }
                }
            }
            return resources;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    protected Date getLastModified(Context context, Item item) {
        return item.getLastModified();
    }

    private List<String> getIncludeBundles() {
        Object[] bundles = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("swordv2-server.statement.bundles");
        if (ArrayUtils.isEmpty((Object[])bundles)) {
            bundles = new String[]{"ORIGINAL", "SWORD"};
        }
        ArrayList<String> include = new ArrayList<String>();
        for (Object bit : bundles) {
            String bundleName = ((String)bit).trim().toUpperCase();
            if (include.contains(bundleName)) continue;
            include.add(bundleName);
        }
        return include;
    }

    private String getOriginalDepositsBundle() {
        String swordBundle = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("swordv2-server.bundle.name");
        if (swordBundle == null) {
            swordBundle = "SWORD";
        }
        return swordBundle;
    }

    private Date getDateOfDeposit(Item item) {
        List values = this.itemService.getMetadata((DSpaceObject)item, "dc", "date", "accessioned", "*");
        Date date = new Date();
        if (values != null && values.size() > 0) {
            String strDate = ((MetadataValue)values.get(0)).getValue();
            date = new DCDate(strDate).toDate();
        }
        return date;
    }
}

