/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.TempFileInputStream;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class SimpleZipContentDisseminator
implements SwordContentDisseminator {
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public InputStream disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        try {
            String tempDir = this.configurationService.getProperty("upload.temp.dir");
            String fn = tempDir + File.separator + "SWORD." + item.getID() + "." + UUID.randomUUID().toString() + ".zip";
            FileOutputStream outStream = new FileOutputStream(new File(fn));
            ZipOutputStream zip = new ZipOutputStream(outStream);
            List bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                List bss = bundle.getBitstreams();
                for (Bitstream bitstream : bss) {
                    ZipEntry ze = new ZipEntry(bitstream.getName());
                    zip.putNextEntry(ze);
                    InputStream is = this.bitstreamService.retrieve(context, bitstream);
                    Utils.copy((InputStream)is, (OutputStream)zip);
                    zip.closeEntry();
                    is.close();
                }
            }
            zip.close();
            return new TempFileInputStream(new File(fn));
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new DSpaceSwordException(e);
        }
    }

    @Override
    public boolean disseminatesContentType(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return "application/zip".equals(contentType);
    }

    @Override
    public boolean disseminatesPackage(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return UriRegistry.PACKAGE_SIMPLE_ZIP.equals(contentType);
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public void setPackaging(String packaging) {
    }

    @Override
    public String getContentType() {
        return "application/zip";
    }

    @Override
    public String getPackaging() {
        return UriRegistry.PACKAGE_SIMPLE_ZIP;
    }
}

