/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class DSpaceSwordAPI {
    private static final Logger log = LogManager.getLogger(DSpaceSwordAPI.class);
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public SwordContext noAuthContext() throws DSpaceSwordException {
        SwordContext sc = new SwordContext();
        Context context = new Context();
        sc.setContext(context);
        return sc;
    }

    public SwordContext doAuth(AuthCredentials authCredentials) throws SwordAuthException, SwordError, DSpaceSwordException {
        if (authCredentials.getUsername() == null) {
            throw new SwordAuthException(true);
        }
        SwordAuthenticator auth = new SwordAuthenticator();
        SwordContext sc = auth.authenticate(authCredentials);
        String un = authCredentials.getUsername() != null ? authCredentials.getUsername() : "NONE";
        String obo = authCredentials.getOnBehalfOf() != null ? authCredentials.getOnBehalfOf() : "NONE";
        log.info(LogHelper.getHeader((Context)sc.getContext(), (String)"sword_auth_request", (String)("username=" + un + ",on_behalf_of=" + obo)));
        return sc;
    }

    public String getHeader(Map<String, String> map, String header, String def) {
        for (String key : map.keySet()) {
            if (!key.toLowerCase().equals(header.toLowerCase())) continue;
            return map.get(key);
        }
        return def;
    }

    public TreeMap<Float, List<String>> analyseAccept(String acceptHeader) {
        if (acceptHeader == null) {
            return null;
        }
        String[] parts = acceptHeader.split(",");
        ArrayList<Object[]> unsorted = new ArrayList<Object[]>();
        float highest_q = 0.0f;
        int counter = 0;
        for (String part : parts) {
            String[] components = part.split(";");
            String type = components[0].trim();
            String params = null;
            float q = -1 * ++counter;
            if (components.length == 2) {
                if (components[1].trim().startsWith("q=")) {
                    q = Float.parseFloat(components[1].trim().substring(2));
                    if (q > highest_q) {
                        highest_q = q;
                    }
                } else {
                    params = components[1].trim();
                }
            } else if (components.length == 3) {
                params = components[1].trim();
                q = Float.parseFloat(components[1].trim().substring(2));
                if (q > highest_q) {
                    highest_q = q;
                }
            }
            Object[] res = new Object[]{type, params, Float.valueOf(q)};
            unsorted.add(res);
        }
        float q_range = 1.0f - highest_q;
        TreeMap<Float, List<String>> sorted = new TreeMap<Float, List<String>>();
        for (Object[] oa : unsorted) {
            Float qv;
            Object contentType = (String)oa[0];
            String p = (String)oa[1];
            if (p != null) {
                contentType = (String)contentType + ";" + p;
            }
            if ((qv = (Float)oa[2]).floatValue() > 0.0f) {
                if (sorted.containsKey(qv)) {
                    sorted.get(qv).add((String)contentType);
                    continue;
                }
                ArrayList<Object> cts = new ArrayList<Object>();
                cts.add(contentType);
                sorted.put(qv, cts);
                continue;
            }
            float nq = 1.0f - q_range + -1.0f * qv.floatValue() / (float)counter * q_range;
            if (sorted.containsKey(Float.valueOf(nq))) {
                sorted.get(Float.valueOf(nq)).add((String)contentType);
                continue;
            }
            ArrayList<Object> cts = new ArrayList<Object>();
            cts.add(contentType);
            sorted.put(Float.valueOf(nq), cts);
        }
        return sorted;
    }

    public void isAcceptable(SwordConfigurationDSpace swordConfig, Context context, Deposit deposit, DSpaceObject dso) throws SwordError, DSpaceSwordException {
        if (!swordConfig.isAcceptableContentType(context, deposit.getMimeType(), dso)) {
            log.error("Unacceptable content type detected: " + deposit.getMimeType() + " for object " + dso.getID());
            throw new SwordError(UriRegistry.ERROR_CONTENT, "Unacceptable content type in deposit request: " + deposit.getMimeType());
        }
        if (!swordConfig.isAcceptedPackaging(deposit.getPackaging(), dso)) {
            log.error("Unacceptable packaging type detected: " + deposit.getPackaging() + " for object " + dso.getID());
            throw new SwordError(UriRegistry.ERROR_CONTENT, "Unacceptable packaging type in deposit request: " + deposit.getPackaging());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOriginals(SwordConfigurationDSpace swordConfig, Context context, VerboseDescription verboseDescription, Deposit deposit, DepositResult result) throws DSpaceSwordException, SwordServerException {
        block18: {
            try {
                if (!swordConfig.isKeepOriginal()) break block18;
                verboseDescription.append("DSpace will store an original copy of the deposit, as well as ingesting the item into the archive");
                context.turnOffAuthorisationSystem();
                String bundleName = this.configurationService.getProperty("swordv2-server.bundle.name");
                if (bundleName == null || "".equals(bundleName)) {
                    bundleName = "SWORD";
                }
                Item item = result.getItem();
                List bundles = item.getBundles();
                Bundle swordBundle = null;
                for (Bundle bundle : bundles) {
                    if (!bundleName.equals(bundle.getName())) continue;
                    swordBundle = bundle;
                    break;
                }
                if (swordBundle == null) {
                    swordBundle = this.bundleService.create(context, item, bundleName);
                }
                if (deposit.isMultipart() || deposit.isEntryOnly()) {
                    String entry = deposit.getSwordEntry().toString();
                    ByteArrayInputStream bais = new ByteArrayInputStream(entry.getBytes());
                    Bitstream entryBitstream = this.bitstreamService.create(context, swordBundle, (InputStream)bais);
                    String fn2 = this.createEntryFilename(context, deposit, true);
                    entryBitstream.setName(context, fn2);
                    entryBitstream.setDescription(context, "Original SWORD entry document");
                    BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, "application/xml");
                    if (bf != null) {
                        entryBitstream.setFormat(context, bf);
                    }
                    this.bitstreamService.update(context, (DSpaceObject)entryBitstream);
                    verboseDescription.append("Original entry stored as " + fn2 + ", in item bundle " + swordBundle);
                }
                if (deposit.isMultipart() || deposit.isBinaryOnly()) {
                    Bitstream bitstream;
                    String fn = this.createFilename(context, deposit, true);
                    InputStream fis = null;
                    try {
                        fis = deposit.getInputStream();
                        bitstream = this.bitstreamService.create(context, swordBundle, fis);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException fn2) {}
                        }
                    }
                    bitstream.setName(context, fn);
                    bitstream.setDescription(context, "Original SWORD deposit file");
                    BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getMimeType());
                    if (bf != null) {
                        bitstream.setFormat(context, bf);
                    }
                    this.bitstreamService.update(context, (DSpaceObject)bitstream);
                    if (result.getOriginalDeposit() == null) {
                        result.setOriginalDeposit(bitstream);
                    }
                    verboseDescription.append("Original deposit stored as " + fn + ", in item bundle " + swordBundle);
                }
                this.bundleService.update(context, (DSpaceObject)swordBundle);
                this.itemService.update(context, (DSpaceObject)item);
                context.restoreAuthSystemState();
            }
            catch (IOException | SQLException | AuthorizeException e) {
                log.error("caught exception: ", e);
                throw new DSpaceSwordException(e);
            }
        }
    }

    public String createFilename(Context context, Deposit deposit, boolean original) throws DSpaceSwordException {
        try {
            Object fn;
            BitstreamFormat bf = this.bitstreamFormatService.findByMIMEType(context, deposit.getMimeType());
            List exts = null;
            if (bf != null) {
                exts = bf.getExtensions();
            }
            if ((fn = deposit.getFilename()) == null || "".equals(fn)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                fn = "sword-" + sdf.format(new Date());
                if (original) {
                    fn = (String)fn + ".original";
                }
                if (exts != null) {
                    fn = (String)fn + "." + (String)exts.get(0);
                }
            }
            return fn;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public String createEntryFilename(Context context, Deposit deposit, boolean original) throws DSpaceSwordException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String fn = "sword-" + sdf.format(new Date());
        if (original) {
            fn = fn + ".original";
        }
        return fn + ".xml";
    }

    protected void storePackageAsFile(Deposit deposit, AuthCredentials auth, SwordConfigurationDSpace config) throws IOException {
        String path = config.getFailedPackageDir();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Directory does not exist for writing packages on ingest error.");
        }
        String filenameBase = "sword-" + auth.getUsername() + "-" + new Date().getTime();
        File packageFile = new File(path, filenameBase);
        File headersFile = new File(path, filenameBase + "-headers");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(deposit.getFile()));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packageFile));
        Utils.copy((InputStream)is, (OutputStream)fos);
        ((OutputStream)fos).close();
        ((InputStream)is).close();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(headersFile)));
        pw.println("Filename=" + deposit.getFilename());
        pw.println("Content-Type=" + deposit.getMimeType());
        pw.println("Packaging=" + deposit.getPackaging());
        pw.println("On Behalf of=" + auth.getOnBehalfOf());
        pw.println("Slug=" + deposit.getSlug());
        pw.println("User name=" + auth.getUsername());
        pw.close();
    }

    protected void storeEntryAsFile(Deposit deposit, AuthCredentials auth, SwordConfigurationDSpace config) throws IOException {
        String path = config.getFailedPackageDir();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Directory does not exist for writing packages on ingest error.");
        }
        String filenameBase = "sword-" + auth.getUsername() + "-" + new Date().getTime();
        File packageFile = new File(path, filenameBase);
        File headersFile = new File(path, filenameBase + "-headers");
        String entry = deposit.getSwordEntry().toString();
        ByteArrayInputStream is = new ByteArrayInputStream(entry.getBytes());
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packageFile));
        Utils.copy((InputStream)is, (OutputStream)fos);
        ((OutputStream)fos).close();
        is.close();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(headersFile)));
        pw.println("Filename=" + deposit.getFilename());
        pw.println("Content-Type=" + deposit.getMimeType());
        pw.println("Packaging=" + deposit.getPackaging());
        pw.println("On Behalf of=" + auth.getOnBehalfOf());
        pw.println("Slug=" + deposit.getSlug());
        pw.println("User name=" + auth.getUsername());
        pw.close();
    }

    protected void addVerboseDescription(DepositReceipt receipt, VerboseDescription verboseDescription) {
        boolean includeVerbose = this.configurationService.getBooleanProperty("swordv2-server.verbose-description.receipt.enable");
        if (includeVerbose) {
            receipt.setVerboseDescription(verboseDescription.toString());
        }
    }
}

