/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordEntryDisseminator;
import org.dspace.sword2.SwordStatementDisseminator;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class SwordDisseminatorFactory {
    private SwordDisseminatorFactory() {
    }

    public static SwordContentDisseminator getContentInstance(Map<Float, List<String>> accept, String acceptPackaging) throws DSpaceSwordException, SwordError {
        try {
            SwordContentDisseminator disseminator = null;
            if (accept != null) {
                block2: for (Float q : accept.keySet()) {
                    for (String format : accept.get(q)) {
                        format = format.replace(";", "_");
                        format = format.replace("=", "_");
                        disseminator = (SwordContentDisseminator)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(SwordContentDisseminator.class, format);
                        if (disseminator == null) continue;
                        if (!disseminator.disseminatesPackage(acceptPackaging)) {
                            disseminator = null;
                            continue;
                        }
                        disseminator.setContentType(format);
                        continue block2;
                    }
                }
            }
            if (disseminator == null && acceptPackaging != null) {
                acceptPackaging = acceptPackaging.replace(";", "_");
                acceptPackaging = acceptPackaging.replace("=", "_");
                disseminator = (SwordContentDisseminator)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(SwordContentDisseminator.class, acceptPackaging);
                if (disseminator != null && accept != null) {
                    String disseminateFormat = null;
                    block4: for (Float q : accept.keySet()) {
                        for (String format : accept.get(q)) {
                            if (!disseminator.disseminatesContentType(format)) continue;
                            disseminateFormat = format;
                            continue block4;
                        }
                    }
                    if (StringUtils.isNotEmpty(disseminateFormat)) {
                        disseminator.setContentType(disseminateFormat);
                    } else {
                        disseminator = null;
                    }
                }
            }
            if (disseminator == null) {
                throw new SwordError(UriRegistry.ERROR_CONTENT, 406, "No plugin can disseminate the requested formats");
            }
            disseminator.setPackaging(acceptPackaging);
            return disseminator;
        }
        catch (SwordServerException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public static SwordStatementDisseminator getStatementInstance(Map<Float, List<String>> accept) throws DSpaceSwordException, SwordError {
        SwordStatementDisseminator disseminator = null;
        if (accept != null) {
            block0: for (Float q : accept.keySet()) {
                for (String format : accept.get(q)) {
                    format = format.replace(";", "_");
                    format = format.replace("=", "_");
                    disseminator = (SwordStatementDisseminator)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(SwordStatementDisseminator.class, format);
                    if (disseminator == null) continue;
                    continue block0;
                }
            }
        }
        if (disseminator == null) {
            throw new SwordError(UriRegistry.ERROR_CONTENT, 406, "No plugin can disseminate the requested formats");
        }
        return disseminator;
    }

    public static SwordEntryDisseminator getEntryInstance() throws DSpaceSwordException, SwordError {
        SwordEntryDisseminator disseminator = (SwordEntryDisseminator)CoreServiceFactory.getInstance().getPluginService().getSinglePlugin(SwordEntryDisseminator.class);
        if (disseminator == null) {
            throw new SwordError("http://www.dspace.org/ns/sword/2.0/errors/RepositoryError", "No disseminator configured for handling sword entry documents");
        }
        return disseminator;
    }
}

