/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.UriRegistry;

public class SimpleZipContentIngester
extends AbstractSwordContentIngester {
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    @Override
    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            File depositFile = deposit.getFile();
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = this.workspaceItemService.create(context, collection, true);
                item = wsi.getItem();
            }
            List bundles = item.getBundles();
            Bundle original = null;
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                original = bundle;
                break;
            }
            if (original == null) {
                original = this.bundleService.create(context, item, "ORIGINAL");
            }
            List<Bitstream> derivedResources = this.unzipToBundle(context, depositFile, original);
            this.itemService.addMetadata(context, (DSpaceObject)item, "dc", "title", null, null, "Untitled: " + deposit.getFilename());
            this.itemService.addMetadata(context, (DSpaceObject)item, "dc", "description", null, null, "Zip file deposted by SWORD without accompanying metadata");
            this.setUpdatedDate(context, item, verboseDescription);
            this.setSlug(context, item, deposit.getSlug(), verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setDerivedResources(derivedResources);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private List<Bitstream> unzipToBundle(Context context, File depositFile, Bundle target) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            ZipFile zip = new ZipFile(depositFile);
            ArrayList<Bitstream> derivedResources = new ArrayList<Bitstream>();
            Enumeration<? extends ZipEntry> zenum = zip.entries();
            while (zenum.hasMoreElements()) {
                ZipEntry entry = zenum.nextElement();
                String entryName = entry.getName();
                Path entryPath = Paths.get(entryName, new String[0]).normalize();
                if (entryPath.isAbsolute() || entryPath.startsWith("..")) {
                    throw new SwordError(UriRegistry.ERROR_BAD_REQUEST, "Invalid zip entry: " + entryName);
                }
                InputStream stream = zip.getInputStream(entry);
                Bitstream bs = this.bitstreamService.create(context, target, stream);
                BitstreamFormat format = this.getFormat(context, entryName);
                bs.setFormat(context, format);
                bs.setName(context, entryName);
                this.bitstreamService.update(context, (DSpaceObject)bs);
                derivedResources.add(bs);
            }
            return derivedResources;
        }
        catch (ZipException e) {
            throw new SwordError(UriRegistry.ERROR_BAD_REQUEST, "unable to unzip provided package", (Throwable)e);
        }
        catch (IOException | SQLException e) {
            throw new DSpaceSwordException(e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
    }

    @Override
    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            File depositFile = deposit.getFile();
            List bundles = item.getBundles();
            Bundle original = null;
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                original = bundle;
                break;
            }
            if (original == null) {
                original = this.bundleService.create(context, item, "ORIGINAL");
            }
            List<Bitstream> derivedResources = this.unzipToBundle(context, depositFile, original);
            this.setUpdatedDate(context, item, verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("Replace successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setDerivedResources(derivedResources);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private String getTreatment() throws DSpaceSwordException {
        return "The package has been ingested and unpacked into the item.  Template metadata for the collection has been used, and a default title with the name of the file has been set";
    }
}

