/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSimpleDC;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SimpleDCMetadata;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class FeedContentDisseminator
extends AbstractSimpleDC
implements SwordContentDisseminator {
    @Override
    public InputStream disseminate(Context context, Item item) throws DSpaceSwordException, SwordError, SwordServerException {
        try {
            Abdera abdera = new Abdera();
            Feed feed = abdera.newFeed();
            this.addMetadata(feed, item);
            List bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                if (!"ORIGINAL".equals(bundle.getName())) continue;
                List bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    Entry entry = feed.addEntry();
                    this.populateEntry(context, entry, bitstream);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            feed.writeTo((OutputStream)baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void addMetadata(Feed feed, Item item) {
        SimpleDCMetadata md = this.getMetadata(item);
        Map<String, String> atom = md.getAtom();
        for (String element : atom.keySet()) {
            if (!"author".equals(element)) continue;
            feed.addAuthor(atom.get(element));
        }
        if (feed.getAuthors().isEmpty()) {
            feed.addAuthor(this.configurationService.getProperty("dspace.name"));
        }
    }

    private void populateEntry(Context context, Entry entry, Bitstream bitstream) throws DSpaceSwordException {
        BitstreamFormat format = null;
        try {
            format = bitstream.getFormat(context);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
        String contentType = null;
        if (format != null) {
            contentType = format.getMIMEType();
        }
        SwordUrlManager urlManager = new SwordUrlManager(new SwordConfigurationDSpace(), context);
        String bsUrl = urlManager.getBitstreamUrl(bitstream);
        entry.setId(bsUrl);
        entry.setTitle(bitstream.getName());
        String desc = bitstream.getDescription();
        if ("".equals(desc) || desc == null) {
            desc = bitstream.getName();
        }
        entry.setSummary(desc);
        entry.setUpdated(new Date());
        Abdera abdera = new Abdera();
        Link link = abdera.getFactory().newLink();
        link.setHref(urlManager.getActionableBitstreamUrl(bitstream));
        link.setMimeType(contentType);
        link.setRel("edit-media");
        entry.addLink(link);
        entry.setContent(new IRI(bsUrl), contentType);
    }

    @Override
    public boolean disseminatesContentType(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return "application/atom+xml".equals(contentType) || "application/atom+xml;type=feed".equals(contentType);
    }

    @Override
    public boolean disseminatesPackage(String contentType) throws DSpaceSwordException, SwordError, SwordServerException {
        return true;
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public void setPackaging(String packaging) {
    }

    @Override
    public String getContentType() {
        return "application/atom+xml;type=feed";
    }

    @Override
    public String getPackaging() {
        return null;
    }
}

