/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.atom.Accept;
import org.purl.sword.atom.ContentType;
import org.purl.sword.atom.Title;
import org.purl.sword.base.DcAbstract;
import org.purl.sword.base.QualityValue;
import org.purl.sword.base.SwordAcceptPackaging;
import org.purl.sword.base.SwordCollectionPolicy;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordMediation;
import org.purl.sword.base.SwordService;
import org.purl.sword.base.SwordTreatment;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class Collection
extends XmlElement
implements SwordElementInterface {
    private String location;
    private Title title;
    private List<Accept> accepts;
    private SwordMediation swordMediation;
    private SwordService swordService;
    private DcAbstract dcTermsAbstract;
    private SwordTreatment swordTreatment;
    private SwordCollectionPolicy swordCollectionPolicy;
    private List<SwordAcceptPackaging> acceptPackaging;
    private static Logger log = LogManager.getLogger(Collection.class);
    public static final String ATTRIBUTE_HREF = "href";
    @Deprecated
    public static final String ELEMENT_NAME = "collection";
    private static final XmlName XML_NAME = new XmlName("app", "collection", "http://www.w3.org/2007/app");

    public Collection() {
        super(XML_NAME);
        this.initialise();
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    protected final void initialise() {
        this.location = null;
        this.title = null;
        this.accepts = new ArrayList<Accept>();
        this.acceptPackaging = new ArrayList<SwordAcceptPackaging>();
        this.swordCollectionPolicy = null;
        this.swordMediation = null;
        this.swordService = null;
        this.dcTermsAbstract = null;
        this.swordTreatment = null;
    }

    public Collection(String location) {
        this();
        this.location = location;
    }

    public String[] getAccepts() {
        String[] values = new String[this.accepts.size()];
        Iterator<Accept> iterator = this.accepts.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Accept accept = iterator.next();
            values[i] = accept.getContent();
            ++i;
        }
        return values;
    }

    @Deprecated
    public List<String> getAcceptsList() {
        ArrayList<String> items = new ArrayList<String>();
        for (Accept item : this.accepts) {
            items.add(item.getContent());
        }
        return items;
    }

    public List<Accept> getAcceptList() {
        return this.accepts;
    }

    public void addAccepts(String accepts) {
        this.accepts.add(new Accept(accepts));
    }

    public void clearAccepts() {
        this.accepts.clear();
    }

    public List<SwordAcceptPackaging> getAcceptPackaging() {
        return this.acceptPackaging;
    }

    public void addAcceptPackaging(String acceptPackaging, float qualityValue) {
        this.acceptPackaging.add(new SwordAcceptPackaging(acceptPackaging, qualityValue));
    }

    public void addAcceptPackaging(String acceptPackaging) {
        this.acceptPackaging.add(new SwordAcceptPackaging(acceptPackaging, new QualityValue()));
    }

    public void clearAcceptPackaging() {
        this.acceptPackaging.clear();
    }

    public String getCollectionPolicy() {
        if (this.swordCollectionPolicy == null) {
            return null;
        }
        return this.swordCollectionPolicy.getContent();
    }

    public void setCollectionPolicy(String collectionPolicy) {
        this.swordCollectionPolicy = new SwordCollectionPolicy(collectionPolicy);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean getMediation() {
        if (this.swordMediation == null) {
            return false;
        }
        return this.swordMediation.getContent();
    }

    public boolean isMediationSet() {
        if (this.swordMediation == null) {
            return false;
        }
        return this.swordMediation.isSet();
    }

    public void setMediation(boolean mediation) {
        this.swordMediation = new SwordMediation(mediation);
    }

    public String getAbstract() {
        if (this.dcTermsAbstract == null) {
            return null;
        }
        return this.dcTermsAbstract.getContent();
    }

    public void setAbstract(String abstractString) {
        this.dcTermsAbstract = new DcAbstract(abstractString);
    }

    public String getService() {
        if (this.swordService == null) {
            return null;
        }
        return this.swordService.getContent();
    }

    public void setService(String serviceString) {
        this.swordService = new SwordService(serviceString);
    }

    public void setTitle(String title) {
        if (this.title == null) {
            this.title = new Title();
        }
        this.title.setContent(title);
        this.title.setType(ContentType.TEXT);
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getContent();
    }

    public String getTreatment() {
        if (this.swordTreatment == null) {
            return null;
        }
        return this.swordTreatment.getContent();
    }

    public void setTreatment(String treatment) {
        this.swordTreatment = new SwordTreatment(treatment);
    }

    public String toString() {
        Element element = this.marshall();
        return element.toString();
    }

    @Override
    public Element marshall() {
        Element collection = new Element(this.getQualifiedName(), "http://www.w3.org/2007/app");
        Attribute href = new Attribute(ATTRIBUTE_HREF, this.location);
        collection.addAttribute(href);
        if (this.title == null) {
            this.title = new Title();
            this.title.setContent("Untitled");
        }
        collection.appendChild((Node)this.title.marshall());
        for (Accept item : this.accepts) {
            collection.appendChild((Node)item.marshall());
        }
        Iterator<SwordAcceptPackaging> apIterator = this.acceptPackaging.iterator();
        while (apIterator.hasNext()) {
            collection.appendChild((Node)apIterator.next().marshall());
        }
        if (this.swordCollectionPolicy != null) {
            collection.appendChild((Node)this.swordCollectionPolicy.marshall());
        }
        if (this.dcTermsAbstract != null) {
            collection.appendChild((Node)this.dcTermsAbstract.marshall());
        }
        if (this.swordService != null) {
            collection.appendChild((Node)this.swordService.marshall());
        }
        if (this.swordMediation != null) {
            collection.appendChild((Node)this.swordMediation.marshall());
        }
        if (this.swordTreatment != null) {
            collection.appendChild((Node)this.swordTreatment.marshall());
        }
        return collection;
    }

    @Override
    public void unmarshall(Element collection) throws UnmarshallException {
        this.unmarshall(collection, null);
    }

    public SwordValidationInfo unmarshall(Element collection, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(collection, this.xmlName)) {
            return this.handleIncorrectElement(collection, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributeValidationItems = new ArrayList<SwordValidationInfo>();
        try {
            this.initialise();
            int count = collection.getAttributeCount();
            Attribute a = null;
            for (int i = 0; i < count; ++i) {
                SwordValidationInfo info;
                a = collection.getAttribute(i);
                if (ATTRIBUTE_HREF.equals(a.getQualifiedName())) {
                    this.location = a.getValue();
                    info = new SwordValidationInfo(this.xmlName, new XmlName(a));
                    info.setContentDescription(this.location);
                    attributeValidationItems.add(info);
                    continue;
                }
                info = new SwordValidationInfo(this.xmlName, new XmlName(a), "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(a.getValue());
                attributeValidationItems.add(info);
            }
            Elements elements = collection.getChildElements();
            Element element = null;
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                SwordValidationInfo info;
                element = elements.get(i);
                if (this.isInstanceOf(element, Title.elementName())) {
                    if (this.title == null) {
                        this.title = new Title();
                        validationItems.add(this.title.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(Title.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.INFO);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, Accept.elementName())) {
                    Accept accept = new Accept();
                    SwordValidationInfo info2 = accept.unmarshall(element, validationProperties);
                    this.accepts.add(accept);
                    validationItems.add(info2);
                    continue;
                }
                if (this.isInstanceOf(element, SwordAcceptPackaging.elementName())) {
                    SwordAcceptPackaging packaging = new SwordAcceptPackaging();
                    validationItems.add(packaging.unmarshall(element, validationProperties));
                    this.acceptPackaging.add(packaging);
                    continue;
                }
                if (this.isInstanceOf(element, SwordCollectionPolicy.elementName())) {
                    if (this.swordCollectionPolicy == null) {
                        this.swordCollectionPolicy = new SwordCollectionPolicy();
                        validationItems.add(this.swordCollectionPolicy.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordCollectionPolicy.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.INFO);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, DcAbstract.elementName())) {
                    if (this.dcTermsAbstract == null) {
                        this.dcTermsAbstract = new DcAbstract();
                        validationItems.add(this.dcTermsAbstract.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(DcAbstract.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.INFO);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordService.elementName())) {
                    if (this.swordService == null) {
                        this.swordService = new SwordService();
                        validationItems.add(this.swordService.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordService.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.INFO);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordMediation.elementName())) {
                    if (this.swordMediation == null) {
                        this.swordMediation = new SwordMediation();
                        validationItems.add(this.swordMediation.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordMediation.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (this.isInstanceOf(element, SwordTreatment.elementName())) {
                    if (this.swordTreatment == null) {
                        this.swordTreatment = new SwordTreatment();
                        validationItems.add(this.swordTreatment.unmarshall(element, validationProperties));
                        continue;
                    }
                    if (validationProperties == null) continue;
                    info = new SwordValidationInfo(SwordTreatment.elementName(), "This element has already been included earlier in this document. This element is ignored.", SwordValidationInfoType.WARNING);
                    info.setContentDescription(element.getValue());
                    validationItems.add(info);
                    continue;
                }
                if (validationProperties == null) continue;
                info = new SwordValidationInfo(new XmlName(element), "This element is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(element.getValue());
                validationItems.add(info);
            }
        }
        catch (Exception ex) {
            log.error("Unable to parse an element in collection: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse an element in Collection", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeValidationItems, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    protected SwordValidationInfo validate(List<SwordValidationInfo> existing, List<SwordValidationInfo> attributes, Properties validationContext) {
        boolean validateAll = existing == null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        if (this.accepts == null || this.accepts.size() == 0) {
            result.addValidationInfo(new SwordValidationInfo(Accept.elementName(), "This element is not present, but at least one MUST be included.", SwordValidationInfoType.WARNING));
        }
        if (this.location == null) {
            XmlName attribute = new XmlName("atom", ATTRIBUTE_HREF, "http://www.w3.org/2005/Atom");
            result.addAttributeValidationInfo(new SwordValidationInfo(this.xmlName, attribute, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        }
        if (this.swordMediation == null) {
            result.addValidationInfo(new SwordValidationInfo(SwordMediation.elementName(), "This element is not present, but it SHOULD be included.", SwordValidationInfoType.WARNING));
        }
        if (validateAll) {
            if (this.accepts.size() > 0) {
                Iterator<Accept> acceptIterator = this.accepts.iterator();
                while (acceptIterator.hasNext()) {
                    result.addValidationInfo(acceptIterator.next().validate(validationContext));
                }
            }
            if (this.acceptPackaging.size() > 0) {
                Iterator<SwordAcceptPackaging> apIterator = this.acceptPackaging.iterator();
                while (apIterator.hasNext()) {
                    result.addValidationInfo(apIterator.next().validate(validationContext));
                }
            }
            if (this.location != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_HREF, this.location));
            }
            if (this.title != null) {
                result.addValidationInfo(this.title.validate(validationContext));
            }
            if (this.swordMediation != null) {
                result.addValidationInfo(this.swordMediation.validate(validationContext));
            }
            if (this.swordService != null) {
                result.addValidationInfo(this.swordService.validate(validationContext));
            }
            if (this.swordTreatment != null) {
                result.addValidationInfo(this.swordTreatment.validate(validationContext));
            }
            if (this.swordCollectionPolicy != null) {
                result.addValidationInfo(this.swordCollectionPolicy.validate(validationContext));
            }
            if (this.dcTermsAbstract != null) {
                result.addValidationInfo(this.dcTermsAbstract.validate(validationContext));
            }
        }
        result.addUnmarshallValidationInfo(existing, attributes);
        return result;
    }
}

