/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwordContentPackageTypes {
    private static Logger log = LogManager.getLogger(SwordContentPackageTypes.class);
    private static Properties types;
    private static SwordContentPackageTypes instance;

    public static SwordContentPackageTypes instance() {
        if (instance == null) {
            instance = new SwordContentPackageTypes();
        }
        return instance;
    }

    public boolean isValidType(String uri) {
        return types.containsKey(uri);
    }

    public boolean isEmpty() {
        return types.isEmpty();
    }

    public Enumeration elements() {
        return types.elements();
    }

    public Enumeration keys() {
        return types.keys();
    }

    static {
        try {
            types = new Properties();
            InputStream stream = SwordContentPackageTypes.class.getClassLoader().getResourceAsStream("swordContentPackageTypes.properties");
            if (stream != null) {
                types.loadFromXML(stream);
            }
        }
        catch (Exception ex) {
            log.error("Unable to load sword types property file: " + ex.getMessage());
        }
    }
}

