/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.client.PostDestination;

public class ClientOptions {
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_POST = "post";
    public static final String TYPE_MULTI_POST = "multipost";
    private String accessType = null;
    private String proxyHost = null;
    private int proxyPort = 8080;
    private String username = null;
    private String password = null;
    private String href = null;
    private String filename = null;
    private String filetype = null;
    private boolean noCapture = false;
    private String slug = null;
    private boolean noOp = false;
    private boolean verbose = false;
    private String onBehalfOf = null;
    private String formatNamespace = null;
    private boolean checksumError = false;
    private static final Logger log = LogManager.getLogger();
    private final List<PostDestination> multiPost = new ArrayList<PostDestination>();
    private static final Pattern MULTI_PATTERN = Pattern.compile("(.*?)(\\[(.*?)\\]) {0,1}(:(.*)) {0,1}@(http://.*)");
    private boolean guiMode = true;
    private boolean md5 = false;

    public boolean parseOptions(String[] args) {
        CommandLine command;
        Options options = new Options();
        options.addOption(Option.builder().longOpt("md5").build()).addOption(Option.builder().longOpt("noOp").build()).addOption(Option.builder().longOpt("verbose").build()).addOption(Option.builder().longOpt("cmd").build()).addOption(Option.builder().longOpt("gui").build()).addOption(Option.builder().longOpt("help").build()).addOption(Option.builder().longOpt("nocapture").build());
        Option option = Option.builder().longOpt("host").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("port").hasArg().build();
        options.addOption(option);
        option = Option.builder((String)"u").hasArg().build();
        options.addOption(option);
        option = Option.builder((String)"p").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("href").hasArg().build();
        options.addOption(option);
        option = Option.builder((String)"t").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("file").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("filetype").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("slug").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("onBehalfOf").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("formatNamespace").hasArg().build();
        options.addOption(option);
        option = Option.builder().longOpt("checksumError").build();
        options.addOption(option);
        option = Option.builder().longOpt("dest").hasArg().build();
        options.addOption(option);
        DefaultParser parser = new DefaultParser();
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException ex) {
            log.error(ex.getMessage());
            return false;
        }
        if (command.hasOption("help")) {
            return false;
        }
        this.md5 = command.hasOption("md5");
        this.noOp = command.hasOption("noOp");
        this.verbose = command.hasOption("verbose");
        if (command.hasOption("cmd")) {
            this.guiMode = false;
        }
        if (command.hasOption("gui")) {
            this.guiMode = true;
        }
        this.proxyHost = command.getOptionValue("host");
        if (command.hasOption("port")) {
            this.proxyPort = Integer.parseInt(command.getOptionValue("port"));
        }
        this.username = command.getOptionValue("u");
        this.password = command.getOptionValue("p");
        this.href = command.getOptionValue("href");
        this.accessType = command.getOptionValue("t");
        this.filename = command.getOptionValue("file");
        this.filetype = command.getOptionValue("filetype");
        this.slug = command.getOptionValue("slug");
        this.onBehalfOf = command.getOptionValue("onBehalfOf");
        this.formatNamespace = command.getOptionValue("formatNamespace");
        this.checksumError = command.hasOption("checksumError");
        this.noCapture = command.hasOption("nocapture");
        if (command.hasOption("dest")) {
            String dest = command.getOptionValue("dest");
            Matcher m = MULTI_PATTERN.matcher(dest);
            if (!m.matches()) {
                log.debug("Error with dest parameter. Ignoring value: {}", (Object)dest);
            } else {
                int numGroups = m.groupCount();
                for (int g = 0; g <= numGroups; ++g) {
                    log.debug("Group ({}) is: {}", (Object)g, (Object)m.group(g));
                }
                String group_username = m.group(1);
                String group_onBehalfOf = m.group(3);
                String group_password = m.group(5);
                String group_url = m.group(6);
                PostDestination destination = new PostDestination(group_url, group_username, group_password, group_onBehalfOf);
                this.multiPost.add(destination);
            }
        }
        try {
            if (this.href == null && TYPE_SERVICE.equals(this.accessType)) {
                log.error("No href specified.");
                return false;
            }
            if (this.multiPost.isEmpty() && TYPE_MULTI_POST.equals(this.accessType)) {
                log.error("No destinations specified");
                return false;
            }
            if (this.accessType == null && !this.guiMode) {
                log.error("No access type specified");
                return false;
            }
            if (this.username == null && this.password != null || this.username != null && this.password == null) {
                log.error("The username and/or password are not specified. If one is specified, the other must also be specified.");
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            log.error("Error with parameters.");
            return false;
        }
        return true;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFiletype() {
        return this.filetype;
    }

    public void setFiletype(String filetype) {
        this.filetype = filetype;
    }

    public boolean isGuiMode() {
        return this.guiMode;
    }

    public void setGuiMode(boolean guiMode) {
        this.guiMode = guiMode;
    }

    public boolean isMd5() {
        return this.md5;
    }

    public void setMd5(boolean md5) {
        this.md5 = md5;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public void setNoOp(boolean noOp) {
        this.noOp = noOp;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf;
    }

    public void setOnBehalfOf(String onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public String getFormatNamespace() {
        return this.formatNamespace;
    }

    public void setFormatNamespace(String formatNamespace) {
        this.formatNamespace = formatNamespace;
    }

    public boolean getChecksumError() {
        return this.checksumError;
    }

    public void setChecksumError(boolean checksumError) {
        this.checksumError = checksumError;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public Iterator<PostDestination> getMultiPost() {
        return this.multiPost.iterator();
    }

    public boolean isNoCapture() {
        return this.noCapture;
    }
}

