/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.base.ChecksumUtils;
import org.purl.sword.base.DepositResponse;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.client.PostMessage;
import org.purl.sword.client.SWORDClient;
import org.purl.sword.client.SWORDClientException;
import org.purl.sword.client.Status;

public class Client
implements SWORDClient {
    private Status status;
    private String server;
    private int port;
    private boolean doAuthentication;
    private String username;
    private String password;
    private String userAgent;
    private final DefaultHttpClient client = new DefaultHttpClient();
    public static final int DEFAULT_TIMEOUT = 20000;
    private static final Logger log = LogManager.getLogger(Client.class);
    private SwordValidationInfo lastUnmarshallInfo;

    public Client() {
        HttpParams params = this.client.getParams();
        params.setParameter("http.socket.timeout", (Object)20000);
        HttpHost proxyHost = (HttpHost)params.getParameter("http.route.default-proxy");
        log.debug("proxy host: " + proxyHost.getHostName());
        log.debug("proxy port: " + proxyHost.getPort());
        this.doAuthentication = false;
    }

    @Override
    public void setServer(String server, int port) {
        this.server = server;
        this.port = port;
    }

    @Override
    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        this.doAuthentication = true;
    }

    private void setBasicCredentials(String username, String password) {
        log.debug("server: " + this.server + " port: " + this.port + " u: '" + username + "' p '" + password + "'");
        this.client.getCredentialsProvider().setCredentials(new AuthScope(this.server, this.port), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public void setProxy(String host) {
        this.setProxy(host, 80);
    }

    @Override
    public void setProxy(String host, int port) {
        this.client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port));
    }

    public void clearProxy() {
        this.client.getParams().removeParameter("http.route.default-proxy");
    }

    @Override
    public void clearCredentials() {
        this.client.getCredentialsProvider().clear();
        this.doAuthentication = false;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setSocketTimeout(int milliseconds) {
        this.client.getParams().setParameter("http.socket.timeout", (Object)milliseconds);
    }

    @Override
    public ServiceDocument getServiceDocument(String url) throws SWORDClientException {
        return this.getServiceDocument(url, null);
    }

    @Override
    public ServiceDocument getServiceDocument(String url, String onBehalfOf) throws SWORDClientException {
        ServiceDocument doc;
        block14: {
            URL serviceDocURL = null;
            try {
                serviceDocURL = new URL(url);
            }
            catch (MalformedURLException e) {
                URL baseURL = null;
                try {
                    baseURL = new URL("http", this.server, this.port, "/");
                    serviceDocURL = new URL(baseURL, url == null ? "" : url);
                }
                catch (MalformedURLException e1) {
                    throw new SWORDClientException(url + " is not a valid URL (" + e1.getMessage() + "), and could not form a relative one from: " + baseURL + " / " + url, e1);
                }
            }
            HttpGet httpget = new HttpGet(serviceDocURL.toExternalForm());
            if (this.doAuthentication) {
                this.setBasicCredentials(this.username, this.password);
            }
            Properties properties = new Properties();
            if (this.containsValue(onBehalfOf)) {
                log.debug("Setting on-behalf-of: " + onBehalfOf);
                httpget.addHeader(url, url);
                httpget.addHeader("X-On-Behalf-Of", onBehalfOf);
                properties.put("X-On-Behalf-Of", onBehalfOf);
            }
            if (this.containsValue(this.userAgent)) {
                log.debug("Setting userAgent: " + this.userAgent);
                httpget.addHeader("User-Agent", this.userAgent);
                properties.put("User-Agent", this.userAgent);
            }
            doc = null;
            try {
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpget);
                StatusLine statusLine = response.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                this.status = new Status(statusCode, statusLine.getReasonPhrase());
                if (this.status.getCode() == 200) {
                    String message = this.readResponse(response.getEntity().getContent());
                    log.debug("returned message is: " + message);
                    doc = new ServiceDocument();
                    this.lastUnmarshallInfo = doc.unmarshall(message, properties);
                    break block14;
                }
                throw new SWORDClientException("Received error from service document request: " + this.status);
            }
            catch (IOException ioex) {
                throw new SWORDClientException(ioex.getMessage(), ioex);
            }
            catch (UnmarshallException uex) {
                throw new SWORDClientException(uex.getMessage(), uex);
            }
            finally {
                httpget.releaseConnection();
            }
        }
        return doc;
    }

    public SwordValidationInfo getLastUnmarshallInfo() {
        return this.lastUnmarshallInfo;
    }

    @Override
    public DepositResponse postFile(PostMessage message) throws SWORDClientException {
        if (message == null) {
            throw new SWORDClientException("Message cannot be null.");
        }
        HttpPost httppost = new HttpPost(message.getDestination());
        if (this.doAuthentication) {
            this.setBasicCredentials(this.username, this.password);
        }
        DepositResponse response = null;
        String messageBody = "";
        try {
            String userAgent;
            String onBehalfOf;
            String filename;
            if (message.isUseMD5()) {
                String md5 = ChecksumUtils.generateMD5(message.getFilepath());
                if (message.getChecksumError()) {
                    md5 = "1234567890";
                }
                log.debug("checksum error is: " + md5);
                if (md5 != null) {
                    httppost.addHeader("Content-MD5", md5);
                }
            }
            if (!"".equals(filename = message.getFilename())) {
                httppost.addHeader("Content-Disposition", " filename=" + filename);
            }
            if (this.containsValue(message.getSlug())) {
                httppost.addHeader("Slug", message.getSlug());
            }
            if (message.getCorruptRequest()) {
                httppost.addHeader("X-No-Op", "Wibble");
            } else {
                httppost.addHeader("X-No-Op", Boolean.toString(message.isNoOp()));
            }
            httppost.addHeader("X-Verbose", Boolean.toString(message.isVerbose()));
            String packaging = message.getPackaging();
            if (packaging != null && packaging.length() > 0) {
                httppost.addHeader("X-Packaging", packaging);
            }
            if (this.containsValue(onBehalfOf = message.getOnBehalfOf())) {
                httppost.addHeader("X-On-Behalf-Of", onBehalfOf);
            }
            if (this.containsValue(userAgent = message.getUserAgent())) {
                httppost.addHeader("User-Agent", userAgent);
            }
            FileEntity requestEntity = new FileEntity(new File(message.getFilepath()), ContentType.create((String)message.getFiletype()));
            httppost.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)httppost);
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            this.status = new Status(statusCode, statusLine.getReasonPhrase());
            log.info("Checking the status code: " + this.status.getCode());
            if (this.status.getCode() == 202 || this.status.getCode() == 201) {
                messageBody = this.readResponse(httpResponse.getEntity().getContent());
                response = new DepositResponse(this.status.getCode());
                response.setLocation(httpResponse.getFirstHeader("Location").getValue());
                this.lastUnmarshallInfo = response.unmarshall(messageBody, new Properties());
            } else {
                messageBody = this.readResponse(httpResponse.getEntity().getContent());
                response = new DepositResponse(this.status.getCode());
                response.unmarshallErrorDocument(messageBody);
            }
            DepositResponse depositResponse = response;
            return depositResponse;
        }
        catch (NoSuchAlgorithmException nex) {
            throw new SWORDClientException("Unable to use MD5. " + nex.getMessage(), nex);
        }
        catch (IOException ioex) {
            throw new SWORDClientException(ioex.getMessage(), ioex);
        }
        catch (UnmarshallException uex) {
            throw new SWORDClientException(uex.getMessage() + "(<pre>" + messageBody + "</pre>)", uex);
        }
        finally {
            httppost.releaseConnection();
        }
    }

    private String readResponse(InputStream stream) throws UnsupportedEncodingException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    private boolean containsValue(String item) {
        return item != null && item.trim().length() > 0;
    }
}

