/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.SWORDErrorDocument;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.UnmarshallException;

public class DepositResponse {
    private SWORDEntry entry = new SWORDEntry();
    private int httpResponse;
    private String location;
    private static Logger log = LogManager.getLogger(DepositResponse.class);

    public DepositResponse(int httpResponse) {
        this.httpResponse = httpResponse;
        this.location = null;
    }

    public void setEntry(SWORDEntry entry) {
        this.entry = entry;
    }

    public SWORDEntry getEntry() {
        return this.entry;
    }

    public SWORDErrorDocument getErrorDocument() throws SWORDException {
        if (this.entry instanceof SWORDErrorDocument) {
            return (SWORDErrorDocument)this.entry;
        }
        throw new SWORDException("Requested document is not an Error Document.");
    }

    public int getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(int httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String marshall() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)stream, "UTF-8");
            serializer.setIndent(3);
            if (this.entry != null) {
                Document doc = new Document(this.entry.marshall());
                serializer.write(doc);
                log.info(stream.toString());
                return stream.toString();
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
        }
        return null;
    }

    public void unmarshall(String xml) throws UnmarshallException {
        this.unmarshall(xml, null);
    }

    public SwordValidationInfo unmarshall(String xml, Properties validationContext) throws UnmarshallException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(xml, "http://www.w3.org/2005/Atom");
            Element root = doc.getRootElement();
            this.entry = new SWORDEntry();
            return this.entry.unmarshall(root, validationContext);
        }
        catch (ParsingException ex) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new UnmarshallException("Error acessing the file?", ex);
        }
    }

    public void unmarshallErrorDocument(String xml) throws UnmarshallException {
        this.unmarshallErrorDocument(xml, null);
    }

    public SwordValidationInfo unmarshallErrorDocument(String xml, Properties validationContext) throws UnmarshallException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(xml, "http://purl.org/net/sword/");
            Element root = doc.getRootElement();
            SWORDErrorDocument sed = new SWORDErrorDocument();
            SwordValidationInfo info = sed.unmarshall(root, validationContext);
            this.entry = sed;
            return info;
        }
        catch (ParsingException ex) {
            throw new UnmarshallException("Unable to parse the XML", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new UnmarshallException("Error acessing the file?", ex);
        }
    }

    public String toString() {
        return this.marshall();
    }
}

