/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.configuration;

import javax.servlet.Servlet;
import org.purl.sword.server.AtomDocumentServlet;
import org.purl.sword.server.DepositServlet;
import org.purl.sword.server.ServiceDocumentServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SWORDWebConfig {
    @Value(value="${sword-server.path:sword}")
    private String swordPath;
    @Value(value="${sword-server.class:org.dspace.sword.DSpaceSWORDServer}")
    private String serverClass;
    @Value(value="${sword-server.authentication-method:Basic}")
    private String authenticationMethod;

    @Bean
    @ConditionalOnProperty(value={"sword-server.enabled"})
    public ServletContextInitializer swordv1ContextInitializer() {
        return servletContext -> {
            servletContext.setInitParameter("sword-server-class", this.serverClass);
            servletContext.setInitParameter("authentication-method", this.authenticationMethod);
        };
    }

    @Bean
    @ConditionalOnProperty(value={"sword-server.enabled"})
    public ServletRegistrationBean swordv1ServiceDocumentBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new ServiceDocumentServlet(), new String[]{"/" + this.swordPath + "/servicedocument/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"sword-server.enabled"})
    public ServletRegistrationBean swordv1DepositBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new DepositServlet(), new String[]{"/" + this.swordPath + "/deposit/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"sword-server.enabled"})
    public ServletRegistrationBean swordv1MediaLinkBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new AtomDocumentServlet(), new String[]{"/" + this.swordPath + "/media-link/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }
}

