/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils.servlet;

import jakarta.annotation.Priority;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.services.RequestService;

@Priority(value=1)
public final class DSpaceWebappServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.getKernel();
        }
        catch (IllegalStateException e) {
            String message = "Could not start up DSpaceWebappServletFilter because the DSpace Kernel is unavailable or not running: " + e.getMessage();
            System.err.println(message);
            throw new ServletException(message, (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DSpaceKernel kernel = this.getKernel();
        RequestService requestService = kernel.getServiceManager().getServiceByName(RequestService.class.getName(), RequestService.class);
        if (requestService == null) {
            throw new IllegalStateException("Could not get the DSpace RequestService to start the request transaction");
        }
        requestService.startRequest(request, response);
        try {
            chain.doFilter(request, response);
            requestService.endRequest(null);
        }
        catch (Exception e) {
            requestService.endRequest(e);
            throw new ServletException((Throwable)e);
        }
    }

    public DSpaceKernel getKernel() {
        DSpaceKernel kernel = new DSpaceKernelManager().getKernel();
        if (!kernel.isRunning()) {
            throw new IllegalStateException("The DSpace kernel is not running: " + kernel);
        }
        return kernel;
    }
}

