/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.config;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.io.ClassPathResource;

public final class DSpaceConfigurationService
implements ConfigurationService {
    private static final Logger log = LogManager.getLogger();
    public static final String DSPACE = "dspace";
    public static final String EXT_CONFIG = "cfg";
    public static final String DOT_CONFIG = ".cfg";
    public static final String DSPACE_HOME = "dspace.dir";
    public static final String DEFAULT_CONFIG_DIR = "config";
    public static final String DEFAULT_CONFIG_DEFINITION_FILE = "config-definition.xml";
    public static final String DSPACE_CONFIG_DEFINITION_PATH = "config" + File.separatorChar + "config-definition.xml";
    public static final String DSPACE_CONFIG_PATH = "config" + File.separatorChar + "dspace.cfg";
    public static final String DSPACE_SERVER_ID = "serverId";
    public static final char CONFIG_LIST_DELIMITER = ',';
    private ReloadingCombinedConfigurationBuilder configurationBuilder = null;
    private String homePath = null;
    private String configDefinition = null;

    public DSpaceConfigurationService() {
        this.loadInitialConfig(null);
    }

    public DSpaceConfigurationService(String providedHome) {
        this.loadInitialConfig(providedHome);
    }

    @Override
    public Properties getProperties() {
        return ConfigurationConverter.getProperties((Configuration)this.getConfiguration());
    }

    @Override
    public List<String> getPropertyKeys() {
        Iterator keys = this.getConfiguration().getKeys();
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasNext()) {
            keyList.add((String)keys.next());
        }
        return keyList;
    }

    @Override
    public List<String> getPropertyKeys(String prefix) {
        Iterator keys = this.getConfiguration().getKeys(prefix);
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasNext()) {
            keyList.add((String)keys.next());
        }
        return keyList;
    }

    @Override
    public Configuration getConfiguration() {
        try {
            return this.configurationBuilder.getConfiguration();
        }
        catch (ConfigurationException ce) {
            log.error("Unable to get configuration object based on definition at {}", (Object)this.configDefinition);
            System.err.println("Unable to get configuration object based on definition at " + this.configDefinition);
            throw new RuntimeException(ce);
        }
    }

    @Override
    public HierarchicalConfiguration<ImmutableNode> getHierarchicalConfiguration() {
        return (CombinedConfiguration)this.getConfiguration();
    }

    @Override
    public List<HierarchicalConfiguration<ImmutableNode>> getChildren(String name) {
        return this.getHierarchicalConfiguration().childConfigurationsAt(name);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getConfiguration().getProperty(name);
    }

    @Override
    public synchronized String getProperty(String name) {
        return this.getProperty(name, null);
    }

    @Override
    public synchronized String getProperty(String name, String defaultValue) {
        return this.getPropertyAsType(name, defaultValue);
    }

    @Override
    public String[] getArrayProperty(String name) {
        return this.getArrayProperty(name, new String[0]);
    }

    @Override
    public String[] getArrayProperty(String name, String[] defaultValue) {
        return this.getPropertyAsType(name, defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getPropertyAsType(name, defaultValue);
    }

    @Override
    public int getIntProperty(String name) {
        return this.getIntProperty(name, 0);
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        return this.getPropertyAsType(name, defaultValue);
    }

    @Override
    public long getLongProperty(String name) {
        return this.getLongProperty(name, 0L);
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        return this.getPropertyAsType(name, defaultValue);
    }

    @Override
    public <T> T getPropertyAsType(String name, Class<T> type) {
        return this.convert(name, type);
    }

    @Override
    public <T> T getPropertyAsType(String name, T defaultValue) {
        return this.getPropertyAsType(name, defaultValue, false);
    }

    @Override
    public <T> T getPropertyAsType(String name, T defaultValue, boolean setDefaultIfNotFound) {
        if (!this.hasProperty(name)) {
            if (setDefaultIfNotFound) {
                this.setProperty(name, defaultValue);
            }
            return defaultValue;
        }
        Class type = Object.class;
        if (defaultValue != null) {
            type = defaultValue.getClass();
        }
        return (T)this.convert(name, type);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getConfiguration().containsKey(name);
    }

    @Override
    public synchronized boolean addPropertyValue(String name, Object value) {
        Configuration configuration;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null for setting configuration");
        }
        if (value == null) {
            throw new IllegalArgumentException("configuration value may not be null");
        }
        if (String.class.isInstance(value)) {
            value = ((String)value).trim();
        }
        boolean isNew = !(configuration = this.getConfiguration()).containsKey(name);
        configuration.addProperty(name, value);
        return isNew;
    }

    @Override
    public synchronized boolean setProperty(String name, Object value) {
        if (value != null && String.class.isInstance(value)) {
            value = ((String)value).trim();
        }
        boolean changed = false;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null for setting configuration");
        }
        Object oldValue = this.getConfiguration().getProperty(name);
        if (value == null && oldValue != null) {
            changed = true;
            this.getConfiguration().clearProperty(name);
            log.info("Cleared the configuration setting for name ({})", (Object)name);
        } else if (value != null && !value.equals(oldValue)) {
            changed = true;
            this.getConfiguration().setProperty(name, value);
        }
        return changed;
    }

    public String[] loadConfiguration(Map<String, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        ArrayList<String> changed = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value;
            String key = entry.getKey();
            boolean updated = this.loadConfig(key, value = entry.getValue());
            if (!updated) continue;
            changed.add(key);
        }
        return changed.toArray(new String[changed.size()]);
    }

    public boolean loadConfig(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (this.getConfiguration().containsKey(key) && this.getConfiguration().getProperty(key).equals(value)) {
            return false;
        }
        this.getConfiguration().setProperty(key, value);
        return true;
    }

    public void clear() {
        this.getConfiguration().clear();
        log.info("Cleared all configuration settings");
    }

    public void clearConfig(String key) {
        this.getConfiguration().clearProperty(key);
    }

    private void loadInitialConfig(String providedHome) {
        this.homePath = this.getDSpaceHome(providedHome);
        this.configDefinition = this.homePath + File.separatorChar + DSPACE_CONFIG_DEFINITION_PATH;
        File configDefFile = new File(this.configDefinition);
        if (!configDefFile.exists()) {
            try {
                ClassPathResource resource = new ClassPathResource(DSPACE_CONFIG_DEFINITION_PATH);
                this.configDefinition = resource.getFile().getAbsolutePath();
            }
            catch (IOException ioe) {
                log.error("Error attempting to load configuration definition from classpath", (Throwable)ioe);
            }
        }
        try {
            Parameters params = new Parameters();
            DefaultListDelimiterHandler listDelimiterHandler = new DefaultListDelimiterHandler(',');
            this.configurationBuilder = new ReloadingCombinedConfigurationBuilder().configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFile(new File(this.configDefinition))).setListDelimiterHandler((ListDelimiterHandler)listDelimiterHandler)});
            this.configurationBuilder.getConfiguration();
            this.configurationBuilder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, e -> this.configurationBuilder.getReloadingController().checkForReloading(null));
        }
        catch (ConfigurationException ce) {
            log.error("Unable to load configurations based on definition at {}", (Object)this.configDefinition);
            System.err.println("Unable to load configurations based on definition at " + this.configDefinition);
            throw new RuntimeException(ce);
        }
        this.setDynamicProperties();
        log.info("Started up configuration service and loaded settings: {}", new Supplier[]{this::toString});
    }

    @Override
    public synchronized void reloadConfig() {
        try {
            this.configurationBuilder.getConfiguration().invalidate();
            this.configurationBuilder.getConfiguration();
            this.setDynamicProperties();
        }
        catch (ConfigurationException ce) {
            log.error("Unable to reload configurations based on definition at {}", (Object)this.configDefinition, (Object)ce);
        }
        log.info("Reloaded configuration service: {}", new Supplier[]{this::toString});
    }

    private void setDynamicProperties() {
        this.setProperty(DSPACE_HOME, this.homePath);
        try {
            String defaultServerId = InetAddress.getLocalHost().getHostName();
            this.setProperty(DSPACE_SERVER_ID, defaultServerId);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String toString() {
        Properties props = this.getProperties();
        int size = props != null ? props.size() : 0;
        return "ConfigDir=" + this.getConfiguration().getString(DSPACE_HOME) + File.separatorChar + "config, Size=" + size;
    }

    protected String getDSpaceHome(String providedHome) {
        String sysProperty = System.getProperty(DSPACE_HOME);
        if (this.isValidDSpaceHome(sysProperty)) {
            return sysProperty;
        }
        if (this.isValidDSpaceHome(providedHome)) {
            return providedHome;
        }
        String pathRelativeToJar = null;
        try {
            URL jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            pathRelativeToJar = new File(jarLocation.toURI()).getParentFile().getParentFile().getAbsolutePath();
            if (this.isValidDSpaceHome(pathRelativeToJar)) {
                return pathRelativeToJar;
            }
        }
        catch (URISyntaxException jarLocation) {
            // empty catch block
        }
        String catalina = this.getCatalina();
        if (this.isValidDSpaceHome(catalina)) {
            return catalina;
        }
        String userHome = System.getProperty("user.home");
        if (this.isValidDSpaceHome(userHome)) {
            return userHome;
        }
        if (this.isValidDSpaceHome("/")) {
            return "/";
        }
        throw new RuntimeException("DSpace home directory could not be determined. It MUST include a subpath of '" + File.separatorChar + DSPACE_CONFIG_DEFINITION_PATH + "'. Please consider setting the 'dspace.dir' system property or ensure the dspace-api.jar is being run from [dspace]/lib/.");
    }

    protected boolean isValidDSpaceHome(String path) {
        if (path == null) {
            return false;
        }
        String configDefinition = path + File.separatorChar + DSPACE_CONFIG_DEFINITION_PATH;
        File configDefFile = new File(configDefinition);
        return configDefFile.exists();
    }

    protected String getCatalina() {
        String catalina = System.getProperty("catalina.base");
        if (catalina == null) {
            catalina = System.getProperty("catalina.home");
        }
        return catalina;
    }

    private <T> T convert(String name, Class<T> type) {
        if (!this.getConfiguration().containsKey(name)) {
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isArray()) {
            return (T)this.getConfiguration().getStringArray(name);
        }
        if (String.class.equals(type) || type.isAssignableFrom(String.class)) {
            return (T)this.getConfiguration().getString(name);
        }
        if (BigDecimal.class.equals(type)) {
            return (T)this.getConfiguration().getBigDecimal(name);
        }
        if (BigInteger.class.equals(type)) {
            return (T)this.getConfiguration().getBigInteger(name);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)Boolean.valueOf(this.getConfiguration().getBoolean(name));
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return (T)Byte.valueOf(this.getConfiguration().getByte(name));
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)Double.valueOf(this.getConfiguration().getDouble(name));
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)Float.valueOf(this.getConfiguration().getFloat(name));
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)Integer.valueOf(this.getConfiguration().getInt(name));
        }
        if (List.class.equals(type)) {
            return (T)this.getConfiguration().getList(name);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)Long.valueOf(this.getConfiguration().getLong(name));
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return (T)Short.valueOf(this.getConfiguration().getShort(name));
        }
        SimpleTypeConverter converter = new SimpleTypeConverter();
        return (T)converter.convertIfNecessary(this.getConfiguration().getProperty(name), type);
    }
}

