/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import jakarta.annotation.PreDestroy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.kernel.Activator;
import org.dspace.kernel.config.SpringLoader;
import org.dspace.kernel.mixins.ConfigChangeListener;
import org.dspace.kernel.mixins.ServiceChangeListener;
import org.dspace.kernel.mixins.ServiceManagerReadyAware;
import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.ServiceManagerUtils;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.servicemanager.spring.DSpaceBeanFactoryPostProcessor;
import org.dspace.utils.CallStackUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class DSpaceServiceManager
implements ServiceManagerSystem {
    private static Logger log = LogManager.getLogger();
    public static final String CONFIG_PATH = "spring/spring-dspace-applicationContext.xml";
    public static final String CORE_RESOURCE_PATH = "classpath*:spring/spring-dspace-core-services.xml";
    public static final String ADDON_RESOURCE_PATH = "classpath*:spring/spring-dspace-addon-*-services.xml";
    private final DSpaceConfigurationService configurationService;
    private ClassPathXmlApplicationContext applicationContext;
    protected boolean running = false;
    protected boolean developing = false;
    protected boolean testing = false;
    protected String[] springXmlConfigFiles = null;
    private final List<Activator> activators = Collections.synchronizedList(new ArrayList());

    public DSpaceServiceManager(DSpaceConfigurationService configurationService) {
        if (configurationService == null) {
            throw new IllegalArgumentException("Failure creating service manager:  configuration service is null");
        }
        this.configurationService = configurationService;
        this.developing = (Boolean)((Object)configurationService.getPropertyAsType("service.manager.developing", Boolean.TYPE));
    }

    protected DSpaceServiceManager(DSpaceConfigurationService configurationService, String ... springXmlConfigFiles) {
        if (configurationService == null) {
            throw new IllegalArgumentException("Configuration service cannot be null");
        }
        this.configurationService = configurationService;
        this.springXmlConfigFiles = springXmlConfigFiles;
        this.testing = true;
        this.developing = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot perform operations on a service manager that is not running");
        }
    }

    public ListableBeanFactory getBeanFactory() {
        if (this.applicationContext != null) {
            return this.applicationContext.getBeanFactory();
        }
        return null;
    }

    public ClassPathXmlApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private void registerActivators() {
        for (Activator activator : this.getServicesByType(Activator.class)) {
            try {
                activator.start(this);
                this.activators.add(activator);
                log.info("Started and registered activator: {}", (Object)activator.getClass().getName());
            }
            catch (Exception e1) {
                log.error("ERROR: Failed to start activator ({}): {}", (Object)activator.getClass().getName(), (Object)e1.getMessage(), (Object)e1);
            }
        }
    }

    private void unregisterActivators() {
        for (Activator activator : this.activators) {
            if (activator == null) continue;
            String activatorClassName = activator.getClass().getName();
            try {
                activator.stop(this);
                log.info("Stopped and unregistered activator: {}", (Object)activatorClassName);
            }
            catch (Exception e1) {
                log.error("ERROR: Failed to stop activator ({}): {}", (Object)activatorClassName, (Object)e1.getMessage(), (Object)e1);
            }
        }
        this.activators.clear();
    }

    public void notifyServiceManagerReady() {
        List<ServiceManagerReadyAware> services = this.getServicesByType(ServiceManagerReadyAware.class);
        for (ServiceManagerReadyAware serviceManagerReadyAware : services) {
            try {
                serviceManagerReadyAware.serviceManagerReady(this);
            }
            catch (Exception e) {
                log.error("ERROR: Failure in service when calling serviceManagerReady: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private boolean checkNotifyServiceChange(List<Class<?>> implementedTypes, ServiceChangeListener serviceChangeListener) {
        boolean notify = false;
        Class<?>[] notifyTypes = serviceChangeListener.notifyForTypes();
        if (notifyTypes == null || notifyTypes.length == 0) {
            notify = true;
        } else {
            block0: for (Class<?> notifyType : notifyTypes) {
                for (Class<?> implementedType : implementedTypes) {
                    if (!notifyType.equals(implementedType)) continue;
                    notify = true;
                    continue block0;
                }
            }
        }
        return notify;
    }

    @Override
    public void shutdown() {
        this.unregisterActivators();
        if (this.applicationContext != null) {
            try {
                this.applicationContext.close();
            }
            catch (Exception e) {
                log.warn("Exception closing ApplicationContext:  {}", (Object)e.getMessage(), (Object)e);
            }
            this.applicationContext = null;
        }
        this.running = false;
        log.info("DSpace service manager is shut down.");
    }

    @Override
    public void startup() {
        Object[] extraConfigs;
        if (!this.testing && (extraConfigs = (String[])this.configurationService.getPropertyAsType("service.manager.spring.configs", String[].class)) != null) {
            this.springXmlConfigFiles = this.springXmlConfigFiles == null ? extraConfigs : (String[])ArrayUtils.addAll((Object[])this.springXmlConfigFiles, (Object[])extraConfigs);
        }
        long startTime = System.currentTimeMillis();
        try {
            this.running = true;
            String[] allPaths = DSpaceServiceManager.getSpringPaths(this.testing, this.springXmlConfigFiles, this.configurationService);
            this.applicationContext = new ClassPathXmlApplicationContext(allPaths, false);
            this.applicationContext.setAllowBeanDefinitionOverriding(true);
            this.applicationContext.setAllowCircularReferences(true);
            this.applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new DSpaceBeanFactoryPostProcessor(this, this.configurationService, this.testing));
            this.applicationContext.refresh();
            if (this.developing) {
                log.warn("Service Manager is running in developmentMode.  Services will be loaded on demand only");
            } else {
                this.applicationContext.getBeanFactory().preInstantiateSingletons();
                this.applicationContext.getBeanFactory().freezeConfiguration();
            }
            this.registerActivators();
            this.notifyServiceManagerReady();
        }
        catch (IllegalStateException e) {
            this.shutdown();
            String message = "Failed to startup the DSpace Service Manager: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        log.info("Service Manager started up in {} ms with {} services...", (Object)totalTime, (Object)this.applicationContext.getBeanDefinitionCount());
    }

    @Override
    public void registerService(String name, Object service) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null");
        }
        try {
            this.applicationContext.getBeanFactory().autowireBean(service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service (" + service + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
        this.registerBean(name, service);
    }

    @Override
    public void registerServiceNoAutowire(String name, Object service) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null");
        }
        this.registerBean(name, service);
    }

    @Override
    public <T> T registerServiceClass(String name, Class<T> type) {
        Object service;
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        try {
            service = this.applicationContext.getBeanFactory().autowire(type, 2, true);
            this.registerBean(name, service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service class (" + type + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
        return (T)service;
    }

    @Override
    public void unregisterService(String name) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.applicationContext.containsBean(name)) {
            try {
                Object beanInstance = this.applicationContext.getBean(name);
                try {
                    this.applicationContext.getBeanFactory().destroyBean(name, beanInstance);
                }
                catch (NoSuchBeanDefinitionException e) {
                    for (Method method : beanInstance.getClass().getMethods()) {
                        if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                        try {
                            method.invoke(beanInstance, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                            log.warn("Failed to call declared @PreDestroy method of {} service", (Object)name, (Object)ex);
                        }
                    }
                }
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
    }

    private void registerBean(String name, Object service) {
        try {
            this.applicationContext.getBeanFactory().initializeBean(service, name);
            this.applicationContext.getBeanFactory().registerSingleton(name, service);
        }
        catch (BeansException e) {
            throw new IllegalArgumentException("Invalid service (" + service + ") with name (" + name + ") registration: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> T getServiceByName(String name, Class<T> type) {
        this.checkRunning();
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        Object service = null;
        if (ApplicationContext.class.getName().equals(name) && ApplicationContext.class.isAssignableFrom(type)) {
            service = this.getApplicationContext();
        } else {
            if (name != null) {
                try {
                    service = this.applicationContext.getBean(name, type);
                }
                catch (BeansException e) {
                    log.debug("Unable to locate bean by name or id={}. Will try to look up bean by type next.", (Object)name);
                    CallStackUtils.logCaller(log, Level.DEBUG);
                    service = null;
                }
            } else {
                try {
                    service = this.applicationContext.getBean(type.getName(), type);
                }
                catch (BeansException e) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = type::getName;
                    log.debug("Unable to locate bean by name or id={}. Will try to look up bean by type next.", supplierArray);
                    CallStackUtils.logCaller(log, Level.DEBUG);
                    service = null;
                }
            }
            if (name == null && service == null) {
                try {
                    Map map = this.applicationContext.getBeansOfType(type);
                    if (map.size() == 1) {
                        service = map.values().iterator().next();
                    } else {
                        log.error("Multiple beans of type {} found. Only one was expected!", (Object)type.getName());
                    }
                }
                catch (BeansException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    service = null;
                }
            }
        }
        return (T)service;
    }

    @Override
    public <T> List<T> getServicesByType(Class<T> type) {
        this.checkRunning();
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        ArrayList services = new ArrayList();
        try {
            Map beans = this.applicationContext.getBeansOfType(type, true, true);
            services.addAll(beans.values());
        }
        catch (BeansException e) {
            throw new RuntimeException("Failed to get beans of type (" + type + "): " + e.getMessage(), e);
        }
        Collections.sort(services, new ServiceManagerUtils.ServiceComparator());
        return services;
    }

    @Override
    public List<String> getServicesNames() {
        String[] singletons;
        this.checkRunning();
        ArrayList<String> beanNames = new ArrayList<String>();
        for (String singleton : singletons = this.applicationContext.getBeanFactory().getSingletonNames()) {
            if (singleton.startsWith("org.springframework.context")) continue;
            beanNames.add(singleton);
        }
        Collections.sort(beanNames);
        return beanNames;
    }

    @Override
    public <T> Map<String, T> getServicesWithNamesByType(Class<T> type) {
        this.checkRunning();
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        try {
            return this.applicationContext.getBeansOfType(type, true, true);
        }
        catch (BeansException e) {
            throw new RuntimeException("Failed to get beans of type (" + type + "): " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isServiceExists(String name) {
        this.checkRunning();
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.applicationContext.containsBean(name);
    }

    @Override
    public Map<String, Object> getServices() {
        String[] singletons;
        this.checkRunning();
        HashMap<String, Object> services = new HashMap<String, Object>();
        for (String singleton : singletons = this.applicationContext.getBeanFactory().getSingletonNames()) {
            if (singleton.startsWith("org.springframework.context")) continue;
            String beanName = singleton;
            Object service = this.applicationContext.getBeanFactory().getSingleton(beanName);
            if (service == null) continue;
            services.put(beanName, service);
        }
        return services;
    }

    @Override
    public void pushConfig(Map<String, Object> properties) {
        String[] changedNames;
        this.checkRunning();
        if (properties != null && !properties.isEmpty() && (changedNames = this.configurationService.loadConfiguration(properties)).length > 0) {
            ArrayList<String> changedSettingNames = new ArrayList<String>();
            LinkedHashMap<String, String> changedSettings = new LinkedHashMap<String, String>();
            for (String configName : changedNames) {
                changedSettingNames.add(configName);
                changedSettings.put(configName, this.configurationService.getProperty(configName));
            }
            List<ConfigChangeListener> configChangeListeners = this.getServicesByType(ConfigChangeListener.class);
            for (ConfigChangeListener configChangeListener : configChangeListeners) {
                try {
                    boolean notify = false;
                    String[] notifyNames = configChangeListener.notifyForConfigNames();
                    if (notifyNames == null || notifyNames.length == 0) {
                        notify = true;
                    } else {
                        block4: for (String notifyName : notifyNames) {
                            for (String changedName : changedNames) {
                                if (notifyName == null || !notifyName.equals(changedName)) continue;
                                notify = true;
                                continue block4;
                            }
                        }
                    }
                    if (!notify) continue;
                    configChangeListener.configurationChanged(changedSettingNames, changedSettings);
                }
                catch (Exception e) {
                    log.error("Failure occurred while trying to notify service of config change: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String[] getSpringPaths(boolean testMode, String[] configPaths, DSpaceConfigurationService configurationService) {
        LinkedList<String> pathList = new LinkedList<String>();
        pathList.add(CONFIG_PATH);
        pathList.add(ADDON_RESOURCE_PATH);
        if (testMode) {
            log.warn("TEST Service Manager running in test mode:  no core beans will be started");
        } else {
            pathList.add(CORE_RESOURCE_PATH);
        }
        if (configPaths != null) {
            pathList.addAll(Arrays.asList(configPaths));
        }
        if (testMode) {
            log.warn("TEST Spring Service Manager running in test mode, no DSpace home Spring files will be loaded");
        } else {
            String[] springLoaderClassNames = configurationService.getArrayProperty("spring.springloader.modules");
            if (springLoaderClassNames != null) {
                for (String springLoaderClassName : springLoaderClassNames) {
                    try {
                        Class<?> springLoaderClass = Class.forName(springLoaderClassName.trim());
                        String[] resourcePaths = ((SpringLoader)springLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0])).getResourcePaths(configurationService);
                        if (resourcePaths == null) continue;
                        pathList.addAll(Arrays.asList(resourcePaths));
                    }
                    catch (ClassNotFoundException springLoaderClass) {
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        log.error("Error while retrieving Spring resource paths for module: {}", (Object)springLoaderClassName, (Object)e);
                    }
                }
            }
        }
        return pathList.toArray(new String[pathList.size()]);
    }
}

