/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.submit.factory.impl.RemovePatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamResourcePolicyRemovePatchOperation
extends RemovePatchOperation<AccessConditionDTO> {
    @Autowired
    ItemService itemService;
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    BitstreamService bitstreamService;

    @Override
    void remove(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String[] split = this.getAbsolutePath(path).split("/");
        String bitstreamIdx = split[1];
        Item item = source.getItem();
        List bundle = this.itemService.getBundles(item, "ORIGINAL");
        Bitstream bitstream = null;
        for (Bundle bb : bundle) {
            int idx = 0;
            for (Bitstream b : bb.getBitstreams()) {
                if (idx == Integer.parseInt(bitstreamIdx)) {
                    if (split.length == 3) {
                        this.resourcePolicyService.removePolicies(context, (DSpaceObject)b, ResourcePolicy.TYPE_CUSTOM);
                    } else {
                        String rpIdx = split[3];
                        List policies = this.resourcePolicyService.find(context, (DSpaceObject)b, ResourcePolicy.TYPE_CUSTOM);
                        int index = 0;
                        for (ResourcePolicy policy : policies) {
                            int toDelete = Integer.parseInt(rpIdx);
                            if (index == toDelete) {
                                b.getResourcePolicies().remove(policy);
                                bitstream = b;
                                break;
                            }
                            ++index;
                        }
                    }
                }
                ++idx;
            }
        }
        if (bitstream != null) {
            this.bitstreamService.update(context, bitstream);
        }
    }

    @Override
    protected Class<AccessConditionDTO[]> getArrayClassForEvaluation() {
        return AccessConditionDTO[].class;
    }

    @Override
    protected Class<AccessConditionDTO> getClassForEvaluation() {
        return AccessConditionDTO.class;
    }
}

