/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.HarvestedCollectionConverter;
import org.dspace.app.rest.link.HalLinkService;
import org.dspace.app.rest.model.HarvestedCollectionRest;
import org.dspace.app.rest.model.hateoas.HarvestedCollectionResource;
import org.dspace.app.rest.repository.HarvestedCollectionRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/collections/{collectionUuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/harvester"})
public class CollectionHarvestSettingsController {
    @Autowired
    HarvestedCollectionConverter harvestedCollectionConverter;
    @Autowired
    CollectionService collectionService;
    @Autowired
    ConverterService converter;
    @Autowired
    HarvestedCollectionService harvestedCollectionService;
    @Autowired
    private HalLinkService halLinkService;
    @Autowired
    HarvestedCollectionRestRepository harvestedCollectionRestRepository;
    @Autowired
    private Utils utils;

    @PreAuthorize(value="hasPermission(#collectionUuid, 'COLLECTION', 'WRITE')")
    @RequestMapping(method={RequestMethod.GET})
    public HarvestedCollectionResource get(@PathVariable UUID collectionUuid, HttpServletRequest request, HttpServletResponse response) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        Collection collection = (Collection)this.collectionService.find(context, collectionUuid);
        if (collection == null) {
            throw new ResourceNotFoundException("Collection with uuid: " + collectionUuid + " not found");
        }
        HarvestedCollectionRest harvestedCollectionRest = this.harvestedCollectionRestRepository.findOne(collection);
        HarvestedCollectionResource resource = (HarvestedCollectionResource)((Object)this.converter.toResource(harvestedCollectionRest));
        return resource;
    }

    @PreAuthorize(value="hasPermission(#collectionUuid, 'COLLECTION', 'WRITE')")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    public HarvestedCollectionResource updateHarvestSettingsEndpoint(@PathVariable UUID collectionUuid, HttpServletResponse response, HttpServletRequest request) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        Collection collection = (Collection)this.collectionService.find(context, collectionUuid);
        HarvestedCollectionResource harvestedCollectionResource = null;
        if (collection == null) {
            throw new ResourceNotFoundException("Collection with uuid: " + collectionUuid + " not found");
        }
        HarvestedCollectionRest harvestedCollectionRest = this.harvestedCollectionRestRepository.update(context, request, collection);
        if (harvestedCollectionRest != null) {
            harvestedCollectionResource = (HarvestedCollectionResource)((Object)this.converter.toResource(harvestedCollectionRest));
        }
        context.commit();
        return harvestedCollectionResource;
    }
}

