/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.submit.factory.impl.AddPatchOperation;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class PrimaryBitstreamAddPatchOperation
extends AddPatchOperation<String> {
    @Autowired
    private ItemService itemService;

    @Override
    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        Item item = source.getItem();
        UUID primaryUUID = this.parseValue(value);
        List bundles = this.itemService.getBundles(item, "ORIGINAL");
        Optional<Bundle> currentPrimaryBundle = bundles.stream().filter(bundle -> Objects.nonNull(bundle.getPrimaryBitstream())).findFirst();
        Optional<Bitstream> primaryBitstreamToAdd = null;
        for (Bundle bundle2 : bundles) {
            primaryBitstreamToAdd = bundle2.getBitstreams().stream().filter(b -> b.getID().equals(primaryUUID)).findFirst();
            if (!primaryBitstreamToAdd.isPresent()) continue;
            if (currentPrimaryBundle.isPresent()) {
                currentPrimaryBundle.get().setPrimaryBitstreamID(null);
            }
            bundle2.setPrimaryBitstreamID(primaryBitstreamToAdd.get());
            break;
        }
        if (primaryBitstreamToAdd.isEmpty()) {
            throw new UnprocessableEntityException("The provided uuid: " + primaryUUID + " of bitstream to set as primary doesn't match any bitstream!");
        }
    }

    private UUID parseValue(Object value) {
        UUID primaryBitstreamUUID;
        try {
            primaryBitstreamUUID = UUID.fromString((String)value);
        }
        catch (Exception e) {
            throw new UnprocessableEntityException("The provided value is invalid!", e);
        }
        return primaryBitstreamUUID;
    }

    @Override
    protected Class<String[]> getArrayClassForEvaluation() {
        return null;
    }

    @Override
    protected Class<String> getClassForEvaluation() {
        return null;
    }
}

