/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.ldn.NotifyServicePatchUtils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceEnabledReplaceOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private NotifyServicePatchUtils notifyServicePatchUtils;
    private static final String OPERATION_PATH = "/enabled";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) throws SQLException {
        this.checkOperationValue(operation.getValue());
        Boolean enabled = this.getBooleanOperationValue(operation.getValue());
        if (this.supports(notifyServiceEntity, operation)) {
            notifyServiceEntity.setEnabled(enabled.booleanValue());
            this.notifyService.update(context, notifyServiceEntity);
            return notifyServiceEntity;
        }
        throw new DSpaceBadRequestException("NotifyServiceEnabledReplaceOperation does not support this operation");
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().toLowerCase().equalsIgnoreCase(OPERATION_PATH);
    }
}

