/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Community;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.communities.subcommunities")
public class CommunitySubcommunityLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    CommunityService communityService;
    @Autowired
    SearchService searchService;

    @PreAuthorize(value="hasPermission(#communityId, 'COMMUNITY', 'READ')")
    public Page<CommunityRest> getSubcommunities(@Nullable HttpServletRequest request, UUID communityId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Community community = (Community)this.communityService.find(context, communityId);
            if (community == null) {
                throw new ResourceNotFoundException("No such community: " + communityId);
            }
            Pageable pageable = this.utils.getPageable(optionalPageable);
            LinkedList<Community> publicSubcommunities = new LinkedList<Community>();
            IndexObjectFactoryFactory indexObjectFactory = IndexObjectFactoryFactory.getInstance();
            IndexableObject scopeObject = (IndexableObject)indexObjectFactory.getIndexableObjects(context, (Object)community).get(0);
            DiscoverQuery discoverQuery = new DiscoverQuery();
            discoverQuery.setQuery("*:*");
            discoverQuery.setDSpaceObjectFilter(IndexableCommunity.TYPE);
            discoverQuery.addFilterQueries(new String[]{"location.parent:" + communityId});
            discoverQuery.setStart(Math.toIntExact(pageable.getOffset()));
            discoverQuery.setMaxResults(pageable.getPageSize());
            discoverQuery.setSortField("dc.title_sort", DiscoverQuery.SORT_ORDER.asc);
            Iterator orderIterator = pageable.getSort().iterator();
            if (orderIterator.hasNext()) {
                Sort.Order order = (Sort.Order)orderIterator.next();
                discoverQuery.setSortField(order.getProperty() + "_sort", order.getDirection().isAscending() ? DiscoverQuery.SORT_ORDER.asc : DiscoverQuery.SORT_ORDER.desc);
            }
            DiscoverResult resp = this.searchService.search(context, scopeObject, discoverQuery);
            long tot = resp.getTotalSearchResults();
            for (IndexableObject solrCommunities : resp.getIndexableObjects()) {
                Community c = (Community)((IndexableCommunity)solrCommunities).getIndexedObject();
                publicSubcommunities.add(c);
            }
            return this.converter.toRestPage(publicSubcommunities, pageable, tot, this.utils.obtainProjection());
        }
        catch (SQLException | SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

