/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.versioning.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionConverter
implements DSpaceConverter<Version, VersionRest> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private RequestService requestService;

    @Override
    public VersionRest convert(Version modelObject, Projection projection) {
        VersionRest versionRest = new VersionRest();
        versionRest.setCreated(modelObject.getVersionDate());
        versionRest.setId(modelObject.getID());
        versionRest.setSummary(modelObject.getSummary());
        this.setSubmitterName(modelObject, versionRest);
        versionRest.setVersion(modelObject.getVersionNumber());
        versionRest.setProjection(projection);
        return versionRest;
    }

    private void setSubmitterName(Version modelObject, VersionRest versionRest) {
        Context context = null;
        Request currentRequest = this.requestService.getCurrentRequest();
        if (currentRequest != null) {
            context = ContextUtil.obtainContext(currentRequest.getHttpServletRequest());
        }
        try {
            EPerson submitter;
            if ((context != null && this.authorizeService.isAdmin(context) || this.configurationService.getBooleanProperty("versioning.item.history.include.submitter")) && (submitter = modelObject.getEPerson()) != null) {
                versionRest.setSubmitterName(submitter.getFullName());
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Class<Version> getModelClass() {
        return Version.class;
    }
}

