/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.exception.RESTBitstreamNotFoundException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component
public class BitstreamRemoveOperation
extends PatchOperation<Bitstream> {
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    AuthorizeService authorizeService;
    public static final String OPERATION_PATH_BITSTREAM_REMOVE = "/bitstreams/";

    @Override
    public Bitstream perform(Context context, Bitstream resource, Operation operation) throws SQLException {
        String bitstreamIDtoDelete = operation.getPath().replace(OPERATION_PATH_BITSTREAM_REMOVE, "");
        Bitstream bitstreamToDelete = this.bitstreamService.find(context, UUID.fromString(bitstreamIDtoDelete));
        if (bitstreamToDelete == null) {
            throw new RESTBitstreamNotFoundException(bitstreamIDtoDelete);
        }
        this.authorizeBitstreamRemoveAction(context, bitstreamToDelete, 2);
        try {
            this.bitstreamService.delete(context, (DSpaceObject)bitstreamToDelete);
        }
        catch (IOException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch == null && operation.getOp().trim().equalsIgnoreCase("remove") && operation.getPath().trim().startsWith(OPERATION_PATH_BITSTREAM_REMOVE);
    }

    public void authorizeBitstreamRemoveAction(Context context, Bitstream bitstream, int operation) throws SQLException {
        try {
            this.authorizeService.authorizeAction(context, (DSpaceObject)bitstream, operation);
        }
        catch (AuthorizeException e) {
            throw new AccessDeniedException("The current user is not allowed to remove the bitstream", (Throwable)e);
        }
    }
}

