/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.model.DiscoveryResultsRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchFacetValueRest;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.SearchFacetValueResource;

public class SearchFacetEntryResource
extends HALResource<SearchFacetEntryRest> {
    @JsonIgnore
    private DiscoveryResultsRest searchData;

    public SearchFacetEntryResource(SearchFacetEntryRest facetData, DiscoveryResultsRest searchData) {
        super(facetData);
        this.searchData = searchData;
        this.addEmbeds();
    }

    public SearchFacetEntryResource(SearchFacetEntryRest facetData) {
        this(facetData, null);
    }

    @JsonIgnore
    public SearchFacetEntryRest getFacetData() {
        return (SearchFacetEntryRest)this.getContent();
    }

    public DiscoveryResultsRest getSearchData() {
        return this.searchData;
    }

    private void addEmbeds() {
        if (this.searchData != null) {
            LinkedList<SearchFacetValueResource> valueResourceList = new LinkedList<SearchFacetValueResource>();
            for (SearchFacetValueRest valueRest : CollectionUtils.emptyIfNull(((SearchFacetEntryRest)this.getContent()).getValues())) {
                SearchFacetValueResource valueResource = new SearchFacetValueResource(valueRest, (SearchFacetEntryRest)this.getContent(), this.searchData);
                valueResourceList.add(valueResource);
            }
            this.embedResource("values", valueResourceList);
        }
    }
}

