/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowdefinitions.collections")
public class WorkflowDefinitionCollectionsLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<CollectionRest> getCollections(@Nullable HttpServletRequest request, String workflowName, @Nullable Pageable optionalPageable, Projection projection) {
        if (this.xmlWorkflowFactory.workflowByThisNameExists(workflowName)) {
            Context context = this.obtainContext();
            ArrayList collectionsMappedToWorkflow = new ArrayList();
            if (this.xmlWorkflowFactory.isDefaultWorkflow(workflowName)) {
                collectionsMappedToWorkflow.addAll(this.xmlWorkflowFactory.getAllNonMappedCollectionsHandles(context));
            }
            collectionsMappedToWorkflow.addAll(this.xmlWorkflowFactory.getCollectionHandlesMappedToWorkflow(context, workflowName));
            Pageable pageable = optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
            return this.converter.toRestPage(collectionsMappedToWorkflow, pageable, projection);
        }
        throw new ResourceNotFoundException("No workflow with name " + workflowName + " is configured");
    }
}

