/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum RestSearchOperator {
    NOTCONTAINS("-(.+)\\*", "notcontains"),
    NOTAUTHORITY("-id:(.+)", "notauthority"),
    NOTEQUALS("-(.+)", "notequals"),
    CONTAINS("(.+)\\*", "contains"),
    AUTHORITY("id:(.+)", "authority"),
    EQUALS("(.+)", "equals");

    private Pattern regex;
    private String dspaceOperator;

    private RestSearchOperator(String regex, String dspaceOperator) {
        this.regex = Pattern.compile(regex);
        this.dspaceOperator = dspaceOperator;
    }

    public String extractValue(String query) {
        Matcher matcher = this.regex.matcher(query);
        matcher.find();
        return matcher.group(1);
    }

    public static RestSearchOperator forQuery(String query) {
        for (RestSearchOperator op : RestSearchOperator.values()) {
            if (!op.getRegex().matcher(query).matches()) continue;
            return op;
        }
        return null;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String getDspaceOperator() {
        return this.dspaceOperator;
    }

    public static List<String> getListOfAllowedSearchOperatorStrings() {
        ArrayList<String> allowedSearchOperatorStrings = new ArrayList<String>();
        for (RestSearchOperator restSearchOperator : Arrays.asList(RestSearchOperator.values())) {
            allowedSearchOperatorStrings.add(restSearchOperator.getDspaceOperator());
        }
        allowedSearchOperatorStrings.add("query");
        return allowedSearchOperatorStrings;
    }
}

