/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import org.dspace.app.ldn.NotifyPatternToTrigger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.submit.factory.impl.NotifySubmissionService;
import org.dspace.app.rest.submit.factory.impl.ReplacePatchOperation;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyServiceReplacePatchOperation
extends ReplacePatchOperation<Integer> {
    @Autowired
    private NotifyPatternToTriggerService notifyPatternToTriggerService;
    @Autowired
    private NotifyService notifyService;
    private NotifySubmissionService coarNotifySubmissionService = (NotifySubmissionService)new DSpace().getServiceManager().getServiceByName("coarNotifySubmissionService", NotifySubmissionService.class);

    @Override
    protected Class<Integer[]> getArrayClassForEvaluation() {
        return Integer[].class;
    }

    @Override
    protected Class<Integer> getClassForEvaluation() {
        return Integer.class;
    }

    @Override
    void replace(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        int index = this.coarNotifySubmissionService.extractIndex(path);
        String pattern = this.coarNotifySubmissionService.extractPattern(path);
        List notifyPatterns = this.notifyPatternToTriggerService.findByItemAndPattern(context, source.getItem(), pattern);
        if (index >= notifyPatterns.size()) {
            throw new DSpaceBadRequestException("the provided index[" + index + "] is out of the rang");
        }
        NotifyServiceEntity notifyServiceEntity = this.notifyService.find(context, Integer.valueOf(Integer.parseInt(value.toString())));
        if (notifyServiceEntity == null) {
            throw new DSpaceBadRequestException("no service found for the provided value: " + value);
        }
        this.coarNotifySubmissionService.checkCompatibilityWithPattern(context, pattern, Set.of(notifyServiceEntity.getID()));
        NotifyPatternToTrigger notifyPatternToTriggerOld = (NotifyPatternToTrigger)notifyPatterns.get(index);
        notifyPatternToTriggerOld.setNotifyService(notifyServiceEntity);
        this.notifyPatternToTriggerService.update(context, notifyPatternToTriggerOld);
    }
}

