/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.stereotype.Component;

@Component
public class WebSecurityExpressionEvaluator {
    private static final FilterChain EMPTY_CHAIN = (request, response) -> {
        throw new UnsupportedOperationException();
    };
    private final List<SecurityExpressionHandler> securityExpressionHandlers;

    public WebSecurityExpressionEvaluator(List<SecurityExpressionHandler> securityExpressionHandlers) {
        this.securityExpressionHandlers = securityExpressionHandlers;
    }

    public boolean evaluate(String securityExpression, HttpServletRequest request, HttpServletResponse response, String id) {
        SecurityExpressionHandler handler = this.getFilterSecurityHandler();
        Expression expression = handler.getExpressionParser().parseExpression(securityExpression);
        EvaluationContext evaluationContext = this.createEvaluationContext(handler, request, response);
        evaluationContext.setVariable("id", (Object)id);
        return ExpressionUtils.evaluateAsBoolean((Expression)expression, (EvaluationContext)evaluationContext);
    }

    private EvaluationContext createEvaluationContext(SecurityExpressionHandler handler, HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        FilterInvocation filterInvocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, EMPTY_CHAIN);
        return handler.createEvaluationContext(authentication, (Object)filterInvocation);
    }

    private SecurityExpressionHandler getFilterSecurityHandler() {
        return this.securityExpressionHandlers.stream().filter(handler -> FilterInvocation.class.equals((Object)GenericTypeResolver.resolveTypeArgument(handler.getClass(), SecurityExpressionHandler.class))).findAny().orElseThrow(() -> new IllegalStateException("No filter invocation security expression handler has been found! Handlers: " + this.securityExpressionHandlers.size()));
    }
}

