/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.repository.handler.ExternalSourceEntryItemUriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceEntryArchivedItemUriListHandler
extends ExternalSourceEntryItemUriListHandler<Item> {
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private InstallItemService installItemService;
    private static final Logger log = LogManager.getLogger(ExternalSourceEntryItemUriListHandler.class);

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        if (!super.supports(uriList, method, clazz)) {
            return false;
        }
        return clazz == Item.class;
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        if (!super.validate(context, request, uriList)) {
            return false;
        }
        try {
            if (!this.authorizeService.isAdmin(context)) {
                throw new AuthorizeException("Only admins are allowed to create items using external data");
            }
        }
        catch (SQLException e) {
            log.error("context isAdmin check resulted in an error", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Item handle(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        String owningCollectionUuid = request.getParameter("owningCollection");
        try {
            WorkspaceItem workspaceItem = super.createWorkspaceItem(context, request, uriList);
            return this.installItemService.installItem(context, (InProgressSubmission)workspaceItem);
        }
        catch (SQLException | AuthorizeException e) {
            log.error("An error occured when trying to create item in collection with uuid: " + owningCollectionUuid, e);
            throw e;
        }
    }
}

