/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueList;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class DSpaceObjectConverter<M extends DSpaceObject, R extends DSpaceObjectRest>
implements DSpaceConverter<M, R> {
    private static final Logger log = LogManager.getLogger(DSpaceObjectConverter.class);
    @Lazy
    @Autowired
    ConverterService converter;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    MetadataExposureService metadataExposureService;
    @Autowired
    RequestService requestService;

    @Override
    public R convert(M obj, Projection projection) {
        R resource = this.newInstance();
        ((RestAddressableModel)resource).setProjection(projection);
        ((DSpaceObjectRest)resource).setHandle(obj.getHandle());
        if (obj.getID() != null) {
            ((DSpaceObjectRest)resource).setUuid(obj.getID().toString());
        }
        ((DSpaceObjectRest)resource).setName(obj.getName());
        MetadataValueList metadataValues = this.getPermissionFilteredMetadata(ContextUtil.obtainCurrentRequestContext(), obj);
        ((DSpaceObjectRest)resource).setMetadata((MetadataRest)this.converter.toRest(metadataValues, projection));
        return resource;
    }

    protected abstract R newInstance();

    public MetadataValueList getPermissionFilteredMetadata(Context context, M obj) {
        List metadata = obj.getMetadata();
        ArrayList<MetadataValue> visibleMetadata = new ArrayList<MetadataValue>();
        try {
            if (context != null && this.authorizeService.isAdmin(context)) {
                return new MetadataValueList(metadata);
            }
            for (MetadataValue mv : metadata) {
                MetadataField metadataField = mv.getMetadataField();
                if (this.metadataExposureService.isHidden(context, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier())) continue;
                visibleMetadata.add(mv);
            }
        }
        catch (SQLException e) {
            log.error("Error filtering metadata based on permissions", (Throwable)e);
        }
        return new MetadataValueList(visibleMetadata);
    }
}

