/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/security"})
@RestController
public class CsrfRestController {
    @Lazy
    @Autowired
    CsrfTokenRepository csrfTokenRepository;

    @GetMapping(value={"/csrf"})
    @PreAuthorize(value="permitAll()")
    public ResponseEntity<RepresentationModel<?>> getCsrf(HttpServletRequest request, HttpServletResponse response, CsrfToken csrfToken) {
        this.csrfTokenRepository.saveToken(csrfToken, request, response);
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

