/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyActionAddOrReplaceOperation<R>
extends PatchOperation<R> {
    @Override
    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.replace(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void replace(ResourcePolicy resourcePolicy, Operation operation) {
        int action = Constants.getActionID((String)operation.getValue().toString());
        if (action < 0 || action > Constants.actionText.length) {
            throw new UnprocessableEntityException(action + "is not defined");
        }
        resourcePolicy.setAction(action);
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResourcePolicy && (operation.getOp().trim().equalsIgnoreCase("add") || operation.getOp().trim().equalsIgnoreCase("replace")) && operation.getPath().trim().equalsIgnoreCase("/action");
    }
}

