/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.rest.repository.handler.ExternalSourceEntryItemUriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceEntryPoolTaskUriListHandler
extends ExternalSourceEntryItemUriListHandler<PoolTask> {
    @Autowired
    private PoolTaskService poolTaskService;

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        return clazz == PoolTask.class;
    }

    @Override
    public PoolTask handle(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        return this.getObjectFromUriList(context, uriList);
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        return uriList.size() <= 1;
    }

    private PoolTask getObjectFromUriList(Context context, List<String> uriList) {
        PoolTask poolTask = null;
        String url = uriList.get(0);
        Pattern pattern = Pattern.compile("\\/api\\/workflow\\/pooltasks\\/(.*)");
        Matcher matcher = pattern.matcher(url);
        matcher.find();
        String id = matcher.group(1);
        int poolTaskId = Integer.parseInt(id);
        try {
            poolTask = (PoolTask)this.poolTaskService.find(context, poolTaskId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return poolTask;
    }
}

