/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.repository.handler.ExternalSourceEntryItemUriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.correctiontype.CorrectionType;
import org.dspace.correctiontype.service.CorrectionTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceCorrectionTypeUriListHandler
extends ExternalSourceEntryItemUriListHandler<CorrectionType> {
    @Autowired
    private CorrectionTypeService correctionTypeService;

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        return clazz == CorrectionType.class;
    }

    @Override
    public CorrectionType handle(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        return this.getObjectFromUriList(context, uriList);
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        return uriList.size() <= 1;
    }

    private CorrectionType getObjectFromUriList(Context context, List<String> uriList) {
        CorrectionType correctionType = null;
        String url = uriList.get(0);
        Pattern pattern = Pattern.compile("\\/api\\/config\\/correctiontypes\\/(.*)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new DSpaceBadRequestException("The uri: " + url + " doesn't resolve to an correction type");
        }
        String id = matcher.group(1);
        try {
            correctionType = this.correctionTypeService.findOne(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return correctionType;
    }
}

