/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateUtils {
    private static Logger log = LogManager.getLogger(DateUtils.class);

    private DateUtils() {
    }

    public static String format(Instant date) {
        Instant truncated = date.truncatedTo(ChronoUnit.SECONDS);
        return DateTimeFormatter.ISO_INSTANT.format(truncated);
    }

    public static Instant parse(String date) {
        DateTimeFormatter format = DateTimeFormatter.ISO_INSTANT;
        try {
            Instant ret = format.parse((CharSequence)date, Instant::from);
            return ret;
        }
        catch (DateTimeParseException ex) {
            format = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            try {
                return format.parse((CharSequence)date, Instant::from);
            }
            catch (DateTimeParseException e1) {
                format = DateTimeFormatter.ISO_LOCAL_DATE;
                try {
                    return format.parse((CharSequence)date, Instant::from);
                }
                catch (DateTimeParseException e2) {
                    format = DateTimeFormatter.ofPattern("yyyy-MM");
                    try {
                        return format.parse((CharSequence)date, Instant::from);
                    }
                    catch (DateTimeParseException e3) {
                        format = DateTimeFormatter.ofPattern("yyyy");
                        try {
                            return format.parse((CharSequence)date, Instant::from);
                        }
                        catch (DateTimeParseException e4) {
                            log.error(e4.getMessage(), (Throwable)e4);
                            return Instant.now();
                        }
                    }
                }
            }
        }
    }

    public static Instant parseFromSolrDate(String date) {
        try {
            Instant ret = Instant.parse(date);
            return ret;
        }
        catch (DateTimeParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Instant.now();
        }
    }
}

