/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.data.Filter;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.filter.Scope;
import com.lyncode.xoai.dataprovider.filter.ScopedFilter;
import com.lyncode.xoai.dataprovider.filter.conditions.Condition;
import com.lyncode.xoai.dataprovider.services.api.ItemRepository;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.dspace.xoai.filter.DSpaceSetSpecFilter;
import org.dspace.xoai.filter.DateFromFilter;
import org.dspace.xoai.filter.DateUntilFilter;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.HandleResolver;

public abstract class DSpaceItemRepository
implements ItemRepository {
    private CollectionsService collectionsService;
    private HandleResolver handleResolver;

    protected DSpaceItemRepository(CollectionsService collectionsService, HandleResolver handleResolver) {
        this.collectionsService = collectionsService;
        this.handleResolver = handleResolver;
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length, Date from) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length, String setSpec) throws OAIException {
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length, Date from, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length, String setSpec, Date from) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length, String setSpec, Date from, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(List<ScopedFilter> filters, int offset, int length, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(List<ScopedFilter> filters, int offset, int length, String setSpec, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItemIdentifiers(filters, offset, length);
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length, Date from) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length, String setSpec) throws OAIException {
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length, Date from, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length, String setSpec, Date from) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length, String setSpec, Date from, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateFromCondition(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItemsUntil(List<ScopedFilter> filters, int offset, int length, Date until) throws OAIException {
        filters.add(new ScopedFilter(this.getDateUntilFilter(until.toInstant()), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    public ListItemsResults getItemsUntil(List<ScopedFilter> filters, int offset, int length, String setSpec, Date from) throws OAIException {
        filters.add(new ScopedFilter(this.getDateUntilFilter(from.toInstant()), Scope.Query));
        filters.add(new ScopedFilter(this.getDSpaceSetSpecFilter(setSpec), Scope.Query));
        return this.getItems(filters, offset, length);
    }

    private Condition getDateFromCondition(final Instant from) {
        return new Condition(){

            public Filter getFilter() {
                return new DateFromFilter(from);
            }
        };
    }

    private Condition getDSpaceSetSpecFilter(final String setSpec) {
        return new Condition(){

            public Filter getFilter() {
                return new DSpaceSetSpecFilter(DSpaceItemRepository.this.collectionsService, DSpaceItemRepository.this.handleResolver, setSpec);
            }
        };
    }

    private Condition getDateUntilFilter(final Instant until) {
        return new Condition(){

            public Filter getFilter() {
                return new DateUntilFilter(until);
            }
        };
    }
}

