/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DateUntilFilter
extends DSpaceFilter {
    private static final DateProvider dateProvider = new BaseDateProvider();
    private final Instant date;

    public DateUntilFilter(Instant date) {
        this.date = date.with(ChronoField.MILLI_OF_SECOND, 999L);
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return !item.getDatestamp().toInstant().isAfter(this.date);
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        Object format = dateProvider.format(Date.from(this.date)).replace("Z", ".999Z");
        if (((String)format).substring(11, 19).equals("00:00:00")) {
            format = ((String)format).substring(0, 11) + "23:59:59" + ((String)format).substring(19);
        }
        return new SolrFilterResult("item.lastmodified:[* TO " + ClientUtils.escapeQueryChars((String)format) + "]");
    }
}

