/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.app.plugins;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.access.status.factory.AccessStatusServiceFactory;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.content.AccessStatus;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.xoai.app.XOAIExtensionItemCompilePlugin;
import org.dspace.xoai.util.ItemUtils;

public class AccessStatusElementItemCompilePlugin
implements XOAIExtensionItemCompilePlugin {
    @Override
    public Metadata additionalMetadata(Context context, Metadata metadata, Item item) {
        AccessStatusService accessStatusService = AccessStatusServiceFactory.getInstance().getAccessStatusService();
        try {
            List elements;
            AccessStatus accessStatusResult = accessStatusService.getAnonymousAccessStatus(context, item);
            String accessStatusType = accessStatusResult.getStatus();
            LocalDate availabilityDate = accessStatusResult.getAvailabilityDate();
            String embargoFromItem = null;
            if (accessStatusType == "embargo" && availabilityDate != null) {
                embargoFromItem = availabilityDate.toString();
            }
            Element accessStatus = ItemUtils.create("access-status");
            accessStatus.getField().add(ItemUtils.createValue("value", accessStatusType));
            if (StringUtils.isNotEmpty((CharSequence)embargoFromItem)) {
                accessStatus.getField().add(ItemUtils.createValue("embargo", embargoFromItem));
            }
            Element others = ItemUtils.getElement(elements = metadata.getElement(), "others") != null ? ItemUtils.getElement(elements, "others") : ItemUtils.create("others");
            others.getElement().add(accessStatus);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return metadata;
    }
}

