/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.HandleResolver;

public class DSpaceSetSpecFilter
extends DSpaceFilter {
    private static final Logger log = LogManager.getLogger(DSpaceSetSpecFilter.class);
    private final String setSpec;
    private final HandleResolver handleResolver;
    private final CollectionsService collectionsService;

    public DSpaceSetSpecFilter(CollectionsService collectionsService, HandleResolver handleResolver, String spec) {
        this.collectionsService = collectionsService;
        this.handleResolver = handleResolver;
        this.setSpec = spec;
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        for (ReferenceSet s : item.getSets()) {
            if (!s.getSetSpec().equals(this.setSpec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        if (this.setSpec.startsWith("col_")) {
            try {
                return new SolrFilterResult("item.collections:" + ClientUtils.escapeQueryChars((String)this.setSpec));
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        } else if (this.setSpec.startsWith("com_")) {
            try {
                return new SolrFilterResult("item.communities:" + ClientUtils.escapeQueryChars((String)this.setSpec));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new SolrFilterResult();
    }
}

