/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import com.lyncode.xoai.util.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xoai.data.DSpaceItem;

public class ItemUtils {
    private static final Logger log = LogManager.getLogger(ItemUtils.class);
    private static final MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    private ItemUtils() {
    }

    public static Element getElement(List<Element> list, String name) {
        for (Element e : list) {
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public static Element create(String name) {
        Element e = new Element();
        e.setName(name);
        return e;
    }

    public static Element.Field createValue(String name, String value) {
        Element.Field e = new Element.Field();
        e.setValue(value);
        e.setName(name);
        return e;
    }

    private static Element createBundlesElement(Context context, Item item) throws SQLException {
        Element bundles = ItemUtils.create("bundles");
        List bs = item.getBundles();
        block0: for (Bundle b : bs) {
            Element bundle = ItemUtils.create("bundle");
            bundles.getElement().add(bundle);
            bundle.getField().add(ItemUtils.createValue("name", b.getName()));
            Element bitstreams = ItemUtils.create("bitstreams");
            bundle.getElement().add(bitstreams);
            List bits = b.getBitstreams();
            for (Bitstream bit : bits) {
                List bi;
                if (bit == null) {
                    log.error("Null bitstream found, check item uuid: " + item.getID());
                    continue block0;
                }
                Element bitstream = ItemUtils.create("bitstream");
                bitstreams.getElement().add(bitstream);
                Object url = "";
                String bsName = bit.getName();
                String sid = String.valueOf(bit.getSequenceID());
                String baseUrl = configurationService.getProperty("oai.bitstream.baseUrl");
                String handle = null;
                List bn = bit.getBundles();
                if (!bn.isEmpty() && !(bi = ((Bundle)bn.get(0)).getItems()).isEmpty()) {
                    handle = ((Item)bi.get(0)).getHandle();
                }
                url = baseUrl + "/bitstreams/" + bit.getID().toString() + "/download";
                String cks = bit.getChecksum();
                String cka = bit.getChecksumAlgorithm();
                String oname = bit.getSource();
                String name = bit.getName();
                String description = bit.getDescription();
                if (name != null) {
                    bitstream.getField().add(ItemUtils.createValue("name", name));
                }
                if (oname != null) {
                    bitstream.getField().add(ItemUtils.createValue("originalName", name));
                }
                if (description != null) {
                    bitstream.getField().add(ItemUtils.createValue("description", description));
                }
                bitstream.getField().add(ItemUtils.createValue("format", bit.getFormat(context).getMIMEType()));
                bitstream.getField().add(ItemUtils.createValue("size", "" + bit.getSizeBytes()));
                bitstream.getField().add(ItemUtils.createValue("url", (String)url));
                bitstream.getField().add(ItemUtils.createValue("checksum", cks));
                bitstream.getField().add(ItemUtils.createValue("checksumAlgorithm", cka));
                bitstream.getField().add(ItemUtils.createValue("sid", "" + bit.getSequenceID()));
            }
        }
        return bundles;
    }

    private static Element createLicenseElement(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        Bundle licBundle;
        List licBits;
        Element license = ItemUtils.create("license");
        List licBundles = itemService.getBundles(item, "LICENSE");
        if (!licBundles.isEmpty() && !(licBits = (licBundle = (Bundle)licBundles.get(0)).getBitstreams()).isEmpty()) {
            Bitstream licBit = (Bitstream)licBits.get(0);
            if (authorizeService.authorizeActionBoolean(context, (DSpaceObject)licBit, 0)) {
                InputStream in = bitstreamService.retrieve(context, licBit);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.bufferedCopy((InputStream)in, (OutputStream)out);
                license.getField().add(ItemUtils.createValue("bin", Base64Utils.encode((String)out.toString())));
            } else {
                log.info("Missing READ rights for license bitstream. Did not include license bitstream for item: " + item.getID() + ".");
            }
        }
        return license;
    }

    private static void fillSchemaElement(Element schema, MetadataValue val) throws SQLException {
        Element language;
        MetadataField field = val.getMetadataField();
        Element valueElem = schema;
        if (field.getElement() != null && !field.getElement().equals("")) {
            Element element = ItemUtils.getElement(schema.getElement(), field.getElement());
            if (element == null) {
                element = ItemUtils.create(field.getElement());
                schema.getElement().add(element);
            }
            valueElem = element;
            if (field.getQualifier() != null && !field.getQualifier().equals("")) {
                Element qualifier = ItemUtils.getElement(element.getElement(), field.getQualifier());
                if (qualifier == null) {
                    qualifier = ItemUtils.create(field.getQualifier());
                    element.getElement().add(qualifier);
                }
                valueElem = qualifier;
            }
        }
        if (val.getLanguage() != null && !val.getLanguage().equals("")) {
            language = ItemUtils.getElement(valueElem.getElement(), val.getLanguage());
            if (language == null) {
                language = ItemUtils.create(val.getLanguage());
                valueElem.getElement().add(language);
            }
            valueElem = language;
        } else {
            language = ItemUtils.getElement(valueElem.getElement(), "none");
            if (language == null) {
                language = ItemUtils.create("none");
                valueElem.getElement().add(language);
            }
            valueElem = language;
        }
        valueElem.getField().add(ItemUtils.createValue("value", val.getValue()));
        if (val.getAuthority() != null) {
            valueElem.getField().add(ItemUtils.createValue("authority", val.getAuthority()));
            if (val.getConfidence() != 0) {
                valueElem.getField().add(ItemUtils.createValue("confidence", "" + val.getConfidence()));
            }
        }
    }

    public static Metadata retrieveMetadata(Context context, Item item) {
        Metadata metadata = new Metadata();
        List vals = itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue val : vals) {
            MetadataField field = val.getMetadataField();
            try {
                if (metadataExposureService.isHidden(context, field.getMetadataSchema().getName(), field.getElement(), field.getQualifier())) continue;
                Element schema = ItemUtils.getElement(metadata.getElement(), field.getMetadataSchema().getName());
                if (schema == null) {
                    schema = ItemUtils.create(field.getMetadataSchema().getName());
                    metadata.getElement().add(schema);
                }
                ItemUtils.fillSchemaElement(schema, val);
            }
            catch (SQLException se) {
                throw new RuntimeException(se);
            }
        }
        try {
            Element bundles = ItemUtils.createBundlesElement(context, item);
            metadata.getElement().add(bundles);
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        Element other = ItemUtils.create("others");
        other.getField().add(ItemUtils.createValue("handle", item.getHandle()));
        other.getField().add(ItemUtils.createValue("identifier", DSpaceItem.buildIdentifier(item.getHandle())));
        other.getField().add(ItemUtils.createValue("lastModifyDate", item.getLastModified().toString()));
        metadata.getElement().add(other);
        Element repository = ItemUtils.create("repository");
        repository.getField().add(ItemUtils.createValue("url", configurationService.getProperty("dspace.ui.url")));
        repository.getField().add(ItemUtils.createValue("name", configurationService.getProperty("dspace.name")));
        repository.getField().add(ItemUtils.createValue("mail", configurationService.getProperty("mail.admin")));
        metadata.getElement().add(repository);
        try {
            Element license = ItemUtils.createLicenseElement(context, item);
            metadata.getElement().add(license);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.warn(e.getMessage(), e);
        }
        return metadata;
    }
}

