/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.ResumptionToken;
import com.lyncode.xoai.dataprovider.exceptions.BadResumptionToken;
import com.lyncode.xoai.dataprovider.services.api.ResumptionTokenFormatter;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.xoai.util.DateUtils;

public class DSpaceResumptionTokenFormatter
implements ResumptionTokenFormatter {
    private static Logger log = LogManager.getLogger(DSpaceResumptionTokenFormatter.class);

    public ResumptionToken parse(String resumptionToken) throws BadResumptionToken {
        if (resumptionToken == null) {
            return new ResumptionToken();
        }
        String[] res = resumptionToken.split("/", -1);
        if (res.length != 5) {
            throw new BadResumptionToken();
        }
        try {
            int offset = Integer.parseInt(res[4]);
            String prefix = res[0].equals("") ? null : res[0];
            String set = res[3].equals("") ? null : res[3];
            Date from = res[1].equals("") ? null : DateUtils.parse(res[1]);
            Date until = res[2].equals("") ? null : DateUtils.parse(res[2]);
            return new ResumptionToken(offset, prefix, set, from, until);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BadResumptionToken();
        }
    }

    public String format(ResumptionToken resumptionToken) {
        Object result = "";
        if (resumptionToken.hasMetadataPrefix()) {
            result = (String)result + resumptionToken.getMetadataPrefix();
        }
        result = (String)result + "/";
        if (resumptionToken.hasFrom()) {
            result = (String)result + DateUtils.format(resumptionToken.getFrom());
        }
        result = (String)result + "/";
        if (resumptionToken.hasUntil()) {
            result = (String)result + DateUtils.format(resumptionToken.getUntil());
        }
        result = (String)result + "/";
        if (resumptionToken.hasSet()) {
            result = (String)result + resumptionToken.getSet();
        }
        result = (String)result + "/";
        result = (String)result + resumptionToken.getOffset();
        return result;
    }
}

